/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.utils.HtmlUtils;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class AgendaContentLinkListener
implements ListenerBase<AgendaEventModification, Object> {
    private static final List<String> EVENT_NAMES = List.of("exo.agenda.event.deleted", "exo.agenda.event.created", "exo.agenda.event.updated", "exo.agenda.event.deleted", "exo.agenda.event.poll.created");
    @Autowired
    private PortalContainer container;
    @Autowired
    private AgendaEventService agendaEventService;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(n -> ((ListenerService)this.container.getComponentInstanceOfType(ListenerService.class)).addListener(n, (ListenerBase)this));
    }

    public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
        AgendaEventModification eventModifications = (AgendaEventModification)event.getSource();
        long eventId = eventModifications.getEventId();
        HtmlProcessorContext context = new HtmlProcessorContext("agendaEvent", String.valueOf(eventId), null);
        org.exoplatform.agenda.model.Event agendaEvent = this.agendaEventService.getEventById(eventId);
        if (agendaEvent == null) {
            HtmlUtils.process((String)"", (HtmlProcessorContext)context);
        } else {
            HtmlUtils.process((String)agendaEvent.getDescription(), (HtmlProcessorContext)context);
        }
    }
}

