/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AgendaDateUtils {
    private static final String ALL_DAY_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm";
    public static final DateTimeFormatter RFC_3339_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX]").withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter ALL_DAY_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter OCCURRENCE_ID_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssXXX").withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter TIMEZONE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm").withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter FULL_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd, yyyy").withResolverStyle(ResolverStyle.LENIENT);

    private AgendaDateUtils() {
    }

    public static ZonedDateTime parseAllDayDateToZonedDateTime(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        return LocalDate.parse(dateString.substring(0, 10), ALL_DAY_FORMATTER).atStartOfDay(ZoneOffset.UTC);
    }

    public static ZonedDateTime parseRFC3339ToZonedDateTime(String dateString, ZoneId zoneId) {
        return AgendaDateUtils.parseRFC3339ToZonedDateTime(dateString, zoneId, true);
    }

    public static ZonedDateTime parseRFC3339ToZonedDateTime(String dateString, ZoneId zoneId, boolean parseTimeZone) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        if (!parseTimeZone) {
            return LocalDateTime.parse(dateString, RFC_3339_FORMATTER).atZone(ZoneId.systemDefault()).withZoneSameLocal(zoneId);
        }
        if (dateString.length() > 20) {
            return ZonedDateTime.parse(dateString, RFC_3339_FORMATTER).withZoneSameInstant(zoneId);
        }
        return LocalDateTime.parse(dateString, RFC_3339_FORMATTER).atZone(zoneId);
    }

    public static String toRFC3339Date(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.format(RFC_3339_FORMATTER);
    }

    public static String toRFC3339Date(ZonedDateTime zonedDateTime, ZoneId zoneOffset, boolean allDay) {
        if (zonedDateTime == null) {
            return null;
        }
        if (zoneOffset == null) {
            zoneOffset = ZoneOffset.UTC;
        }
        if (allDay) {
            return zonedDateTime.withZoneSameLocal(zoneOffset).format(ALL_DAY_FORMATTER);
        }
        return zonedDateTime.withZoneSameInstant(zoneOffset).format(RFC_3339_FORMATTER);
    }

    public static String toRFC3339Date(ZonedDateTime zonedDateTime, ZoneOffset zoneOffset) {
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.withZoneSameInstant(zoneOffset).format(RFC_3339_FORMATTER);
    }

    public static Date parseRFC3339Date(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, RFC_3339_FORMATTER);
        return Date.from(zonedDateTime.toInstant());
    }

    public static String toRFC3339Date(Date dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.from(dateTime.toInstant().atOffset(ZoneOffset.UTC));
        return zonedDateTime.format(RFC_3339_FORMATTER);
    }

    public static Date toDate(ZonedDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return Date.from(datetime.toInstant());
    }

    public static ZonedDateTime fromDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneOffset.UTC);
    }

    public static String buildOccurrenceId(Date formTime) {
        if (formTime == null) {
            return null;
        }
        return OCCURRENCE_ID_FORMATTER.format(formTime.toInstant().atOffset(ZoneOffset.UTC));
    }

    public static String buildOccurrenceId(ZonedDateTime formTime) {
        if (formTime == null) {
            return null;
        }
        return OCCURRENCE_ID_FORMATTER.format(formTime.toInstant().atOffset(ZoneOffset.UTC));
    }

    public static String formatDateTimeWithSeconds(TemporalAccessor dateTime) {
        if (dateTime == null) {
            return null;
        }
        return TIMEZONE_DATE_FORMATTER.format(dateTime);
    }

    public static ZonedDateTime buildOccurrenceDateTime(String occurrenceId) {
        if (StringUtils.isBlank((CharSequence)occurrenceId)) {
            return null;
        }
        return ZonedDateTime.parse(occurrenceId, OCCURRENCE_ID_FORMATTER);
    }

    public static String formatWithHoursAndMinutes(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(TIME_FORMATTER);
    }

    public static String formatWithYearAndMonth(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(FULL_TIME_FORMATTER);
    }

    public static final String getDayNameFromDayAbbreviation(List<String> dayNames) {
        ArrayList<String> daysFinal = new ArrayList<String>();
        if (dayNames != null) {
            Iterator<String> iterator = dayNames.iterator();
            while (iterator.hasNext()) {
                String name;
                switch (name = iterator.next()) {
                    case "MO": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(1))));
                        break;
                    }
                    case "TU": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(2))));
                        break;
                    }
                    case "WE": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(3))));
                        break;
                    }
                    case "TH": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(4))));
                        break;
                    }
                    case "FR": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(5))));
                        break;
                    }
                    case "SA": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(6))));
                        break;
                    }
                    case "SU": {
                        daysFinal.add(StringUtils.lowerCase((String)String.valueOf(DayOfWeek.of(7))));
                    }
                }
            }
        }
        return StringUtils.join(daysFinal, (String)",");
    }
}

