/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage.cached;

import java.io.Serializable;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.storage.AgendaCalendarStorage;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;

public class CachedAgendaCalendarStorage
extends AgendaCalendarStorage {
    public static final String CALENDAR_CACHE_NAME = "agenda.calendar";
    private FutureExoCache<Long, Calendar, Object> calendarFutureCache = null;

    public CachedAgendaCalendarStorage(CacheService cacheService, CalendarDAO calendarDAO, ListenerService listenerService) {
        super(calendarDAO, listenerService);
        ExoCache calendarCache = cacheService.getCacheInstance(CALENDAR_CACHE_NAME);
        this.calendarFutureCache = new FutureExoCache((Loader)new Loader<Long, Calendar, Object>(){

            public Calendar retrieve(Object context, Long calendarId) throws Exception {
                Calendar calendar = CachedAgendaCalendarStorage.super.getCalendarById(calendarId);
                if (calendar != null) {
                    calendar = calendar.clone();
                }
                return calendar;
            }
        }, calendarCache);
    }

    @Override
    public Calendar getCalendarById(long calendarId) {
        return (Calendar)this.calendarFutureCache.get(null, (Object)calendarId);
    }

    @Override
    public void updateCalendar(Calendar calendar) {
        super.updateCalendar(calendar);
        this.calendarFutureCache.remove((Serializable)Long.valueOf(calendar.getId()));
    }

    @Override
    public void deleteCalendarById(long calendarId) {
        super.deleteCalendarById(calendarId);
        this.calendarFutureCache.remove((Serializable)Long.valueOf(calendarId));
    }

    public void clearCache() {
        this.calendarFutureCache.clear();
    }
}

