/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.job;

import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class AgendaEventReminderJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventReminderJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private AgendaEventReminderService agendaEventReminderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.getAgendaEventReminderService().sendReminders();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while computing reminder date of events", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)this.container.getComponentInstanceOfType(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }
}

