/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AgendaESListener
extends Listener<Long, Object> {
    private static final Log LOG = ExoLogger.getExoLogger(AgendaESListener.class);
    private final IndexingService indexingService;

    public AgendaESListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void onEvent(Event<Long, Object> event) throws Exception {
        if (this.indexingService != null) {
            String eventId = Long.toString((Long)event.getSource());
            if ("exo.agenda.event.created".equals(event.getEventName())) {
                this.reindexAgendaEvent(eventId, "create agenda event");
            } else if ("exo.agenda.event.updated".equals(event.getEventName())) {
                this.reindexAgendaEvent(eventId, "update agenda event");
            } else if ("exo.agenda.event.deleted".equals(event.getEventName())) {
                this.unindexAgendaEvent(eventId, "delete agenda event");
            }
        }
    }

    private void reindexAgendaEvent(String eventId, String cause) {
        LOG.debug("Notifying indexing service for event with id={}. Cause: {}", new Object[]{eventId, cause});
        this.indexingService.reindex("event", eventId);
    }

    private void unindexAgendaEvent(String eventId, String cause) {
        LOG.debug("Notifying unindexing service for event with id={}. Cause: {}", new Object[]{eventId, cause});
        this.indexingService.unindex("event", eventId);
    }
}

