/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventOccurrence;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    private static final TimeZoneRegistry ICAL4J_TIME_ZONE_REGISTRY = TimeZoneRegistryFactory.getInstance().createRegistry();
    public static final String POST_CREATE_AGENDA_EVENT_EVENT = "exo.agenda.event.created";
    public static final String POST_UPDATE_AGENDA_EVENT_EVENT = "exo.agenda.event.updated";
    public static final String POST_DELETE_AGENDA_EVENT_EVENT = "exo.agenda.event.deleted";
    public static final String POST_EVENT_RESPONSE_SENT = "exo.agenda.event.responseSent";

    private Utils() {
    }

    public static List<Long> getCalendarOwnersOfUser(SpaceService spaceService, IdentityManager identityManager, Identity userIdentity) {
        ArrayList<Long> calendarOwners = new ArrayList<Long>();
        String userIdentityId = userIdentity.getId();
        calendarOwners.add(Long.parseLong(userIdentityId));
        try {
            Utils.addUserSpacesIdentities(spaceService, identityManager, userIdentity.getRemoteId(), calendarOwners);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while retrieving spaces of user with id: " + userIdentityId, e);
        }
        return calendarOwners;
    }

    public static void addUserSpacesIdentities(SpaceService spaceService, IdentityManager identityManager, String username, List<Long> identityIds) throws Exception {
        int limitToFetch;
        ListAccess userSpaces = spaceService.getMemberSpaces(username);
        int spacesSize = userSpaces.getSize();
        int offsetToFetch = 0;
        int n = limitToFetch = spacesSize > 20 ? 20 : spacesSize;
        while (limitToFetch > 0) {
            Space[] spaces = (Space[])userSpaces.load(offsetToFetch, limitToFetch);
            Arrays.stream(spaces).forEach(space -> {
                Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName());
                identityIds.add(Long.parseLong(spaceIdentity.getId()));
            });
            limitToFetch = spacesSize - (offsetToFetch += limitToFetch) > 20 ? 20 : spacesSize - offsetToFetch;
        }
    }

    public static List<Event> getOccurrences(Event event, LocalDate from, LocalDate to, int limit) {
        DateList dates;
        ZoneId timeZone = event.getTimeZoneId();
        TimeZone ical4jTimezone = Utils.getICalTimeZone(timeZone);
        long startTime = event.isAllDay() ? event.getStart().toLocalDate().atStartOfDay(timeZone).toInstant().toEpochMilli() : event.getStart().toInstant().toEpochMilli();
        long endTime = event.isAllDay() ? event.getEnd().toLocalDate().atStartOfDay(timeZone).plusDays(1L).minusSeconds(1L).toInstant().toEpochMilli() : event.getEnd().toInstant().toEpochMilli();
        DateTime startDateTime = new DateTime(startTime);
        startDateTime.setTimeZone(ical4jTimezone);
        DateTime endDateTime = new DateTime(endTime);
        endDateTime.setTimeZone(ical4jTimezone);
        VEvent vevent = new VEvent((Date)startDateTime, (Date)endDateTime, event.getSummary());
        Recur recur = Utils.getICalendarRecur(event.getRecurrence());
        vevent.getProperties().add((Property)new RRule(recur));
        long fromTime = from.atStartOfDay(timeZone).toInstant().toEpochMilli();
        if (to == null) {
            ZonedDateTime overallEnd = event.getRecurrence().getOverallEnd();
            to = overallEnd == null ? from.plusYears(5L) : overallEnd.withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        }
        long toTime = to.atStartOfDay(timeZone).plusDays(1L).minusSeconds(1L).toEpochSecond() * 1000L;
        DateTime ical4jFrom = new DateTime(fromTime);
        ical4jFrom.setTimeZone(ical4jTimezone);
        DateTime ical4jTo = new DateTime(toTime);
        ical4jTo.setTimeZone(ical4jTimezone);
        DateList dateList = dates = limit > 0 ? recur.getDates((Date)startDateTime, (Date)ical4jFrom, (Date)ical4jTo, null, limit) : recur.getDates((Date)startDateTime, (Date)ical4jFrom, (Date)ical4jTo, null);
        if (dates == null || dates.isEmpty()) {
            return Collections.emptyList();
        }
        List occurrencesIds = dates.stream().map(date -> ((DateTime)date).toInstant().atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toLocalDate()).collect(Collectors.toList());
        if (limit > 0 && dates.size() >= limit) {
            ical4jTo = (DateTime)dates.get(limit - 1);
            long duration = endTime - startTime;
            ical4jTo = new DateTime(ical4jTo.getTime() + duration + 1000L);
            ical4jTo.setTimeZone(ical4jTimezone);
        }
        Period period = new Period(ical4jFrom, ical4jTo);
        period.setTimeZone(ical4jTimezone);
        PeriodList list = vevent.calculateRecurrenceSet(period);
        ArrayList<Event> occurrences = new ArrayList<Event>();
        for (Period occurrencePeriod : list) {
            ZonedDateTime occurrenceId = occurrencePeriod.getStart().toInstant().atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC);
            if (!occurrencesIds.contains(occurrenceId.toLocalDate())) continue;
            Event occurrence = event.clone();
            occurrence.setId(0L);
            occurrence.setStart(occurrencePeriod.getStart().toInstant().atZone(timeZone));
            occurrence.setEnd(occurrencePeriod.getEnd().toInstant().atZone(timeZone));
            occurrence.setOccurrence(new EventOccurrence(occurrenceId, false));
            occurrence.setParentId(event.getId());
            occurrence.setRecurrence(null);
            occurrences.add(occurrence);
        }
        return occurrences;
    }

    public static Recur getICalendarRecur(EventRecurrence recurrence) {
        NumberList list;
        Recur.Builder recurBuilder = new Recur.Builder();
        recurBuilder.frequency(Recur.Frequency.valueOf((String)recurrence.getFrequency().name()));
        recurBuilder.count(Integer.valueOf(recurrence.getCount() > 0 ? recurrence.getCount() : 0));
        recurBuilder.interval(Integer.valueOf(recurrence.getInterval()));
        if (recurrence.getUntil() != null) {
            DateTime dateTime = new DateTime(AgendaDateUtils.toDate(recurrence.getUntil()));
            dateTime.setUtc(true);
            recurBuilder.until((Date)dateTime);
        }
        if (recurrence.getBySecond() != null && !recurrence.getBySecond().isEmpty()) {
            list = new NumberList();
            recurrence.getBySecond().forEach(second -> list.add(Integer.valueOf(Integer.parseInt(second))));
            recurBuilder.secondList(list);
        }
        if (recurrence.getByMinute() != null && !recurrence.getByMinute().isEmpty()) {
            list = new NumberList();
            recurrence.getByMinute().forEach(minute -> list.add(Integer.valueOf(Integer.parseInt(minute))));
            recurBuilder.minuteList(list);
        }
        if (recurrence.getByHour() != null && !recurrence.getByHour().isEmpty()) {
            list = new NumberList();
            recurrence.getByHour().forEach(hour -> list.add(Integer.valueOf(Integer.parseInt(hour))));
            recurBuilder.hourList(list);
        }
        if (recurrence.getByDay() != null && !recurrence.getByDay().isEmpty()) {
            list = new WeekDayList();
            recurrence.getByDay().forEach(arg_0 -> Utils.lambda$getICalendarRecur$5((WeekDayList)list, arg_0));
            recurBuilder.dayList((WeekDayList)list);
        }
        if (recurrence.getByMonthDay() != null && !recurrence.getByMonthDay().isEmpty()) {
            list = new NumberList();
            recurrence.getByMonthDay().forEach(monthDay -> list.add(Integer.valueOf(Integer.parseInt(monthDay))));
            recurBuilder.monthDayList(list);
        }
        if (recurrence.getByYearDay() != null && !recurrence.getByYearDay().isEmpty()) {
            list = new NumberList();
            recurrence.getByYearDay().forEach(yearDay -> list.add(Integer.valueOf(Integer.parseInt(yearDay))));
            recurBuilder.yearDayList(list);
        }
        if (recurrence.getByWeekNo() != null && !recurrence.getByWeekNo().isEmpty()) {
            list = new NumberList();
            recurrence.getByWeekNo().forEach(weekNo -> list.add(Integer.valueOf(Integer.parseInt(weekNo))));
            recurBuilder.weekNoList(list);
        }
        if (recurrence.getByMonth() != null && !recurrence.getByMonth().isEmpty()) {
            list = new NumberList();
            recurrence.getByMonth().forEach(month -> list.add(Integer.valueOf(Integer.parseInt(month))));
            recurBuilder.monthList(list);
        }
        if (recurrence.getBySetPos() != null && !recurrence.getBySetPos().isEmpty()) {
            list = new NumberList();
            recurrence.getBySetPos().forEach(setPos -> list.add(Integer.valueOf(Integer.parseInt(setPos))));
            recurBuilder.setPosList(list);
        }
        return recurBuilder.build();
    }

    public static boolean checkAclByCalendarOwner(IdentityManager identityManager, SpaceService spaceService, long ownerId, String username, boolean readonly) throws IllegalAccessException {
        Identity requestedOwner = identityManager.getIdentity(String.valueOf(ownerId));
        if (requestedOwner == null) {
            throw new IllegalStateException("Calendar owner with id " + ownerId + " wasn't found");
        }
        if (StringUtils.equals((String)"organization", (String)requestedOwner.getProviderId())) {
            if (!StringUtils.equals((String)requestedOwner.getRemoteId(), (String)username)) {
                throw new IllegalAccessException("User " + username + " is not allowed to retrieve calendar data of user " + requestedOwner.getRemoteId());
            }
            return true;
        }
        if (StringUtils.equals((String)"space", (String)requestedOwner.getProviderId())) {
            if (spaceService.isSuperManager(username)) {
                return true;
            }
            Space space = spaceService.getSpaceByPrettyName(requestedOwner.getRemoteId());
            if (!spaceService.isMember(space, username)) {
                throw new IllegalAccessException("User " + username + " is not allowed to retrieve calendar data of space " + requestedOwner.getRemoteId());
            }
            boolean isManager = spaceService.isManager(space, username);
            if (!readonly && !isManager) {
                throw new IllegalAccessException("User " + username + " is not allowed to write calendar data of space " + space.getDisplayName());
            }
            return isManager;
        }
        throw new IllegalStateException("Identity with provider type '" + requestedOwner.getProviderId() + "' is not managed in calendar owner field");
    }

    public static boolean canEditCalendar(IdentityManager identityManager, SpaceService spaceService, long ownerId, long userIdentityId) {
        Identity requestedOwner = identityManager.getIdentity(String.valueOf(ownerId));
        if (requestedOwner == null) {
            return false;
        }
        Identity userIdentity = identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with id " + userIdentity + " wasn't found");
        }
        if (StringUtils.equals((String)"organization", (String)requestedOwner.getProviderId())) {
            return userIdentityId == Long.parseLong(requestedOwner.getId());
        }
        if (StringUtils.equals((String)"space", (String)requestedOwner.getProviderId())) {
            if (spaceService.isSuperManager(userIdentity.getRemoteId())) {
                return true;
            }
            Space space = spaceService.getSpaceByPrettyName(requestedOwner.getRemoteId());
            return space != null && spaceService.isManager(space, userIdentity.getRemoteId());
        }
        return false;
    }

    public static boolean canAccessCalendar(IdentityManager identityManager, SpaceService spaceService, long ownerId, long userIdentityId) {
        Identity requestedOwner = identityManager.getIdentity(String.valueOf(ownerId));
        if (requestedOwner == null) {
            return false;
        }
        Identity userIdentity = identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with id " + userIdentity + " wasn't found");
        }
        if (StringUtils.equals((String)"organization", (String)requestedOwner.getProviderId())) {
            return userIdentityId == Long.parseLong(requestedOwner.getId());
        }
        if (StringUtils.equals((String)"space", (String)requestedOwner.getProviderId())) {
            if (spaceService.isSuperManager(userIdentity.getRemoteId())) {
                return true;
            }
            Space space = spaceService.getSpaceByPrettyName(requestedOwner.getRemoteId());
            return space != null && spaceService.isMember(space, userIdentity.getRemoteId());
        }
        return false;
    }

    public static void broadcastEvent(ListenerService listenerService, String eventName, Object source, Object data) {
        try {
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error broadcasting event '" + eventName + "' using source '" + source + "' and data " + data), (Throwable)e);
        }
    }

    public static Identity getIdentityById(IdentityManager identityManager, long identityId) {
        return Utils.getIdentityById(identityManager, String.valueOf(identityId));
    }

    public static Identity getIdentityById(IdentityManager identityManager, String identityId) {
        return identityManager.getIdentity(identityId);
    }

    public static long getIdentityIdByUsername(IdentityManager identityManager, String username) {
        Identity identity = identityManager.getOrCreateIdentity("organization", username);
        if (identity == null) {
            return 0L;
        }
        return Long.parseLong(identity.getId());
    }

    public static List<String> getSpaceMembersBySpaceName(String spaceName, SpaceService spaceService) {
        String[] members = spaceService.getSpaceByPrettyName(spaceName).getMembers();
        return Arrays.asList(members);
    }

    public static boolean isEventAttendee(IdentityManager identityManager, SpaceService spaceService, long identityId, List<EventAttendee> eventAttendees) {
        Identity userIdentity = identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            return false;
        }
        return eventAttendees != null && eventAttendees.stream().anyMatch(eventAttendee -> {
            Identity identity;
            if (identityId == eventAttendee.getIdentityId()) {
                return true;
            }
            if (StringUtils.equals((String)userIdentity.getProviderId(), (String)"organization") && StringUtils.equals((String)(identity = identityManager.getIdentity(String.valueOf(eventAttendee.getIdentityId()))).getProviderId(), (String)"space")) {
                if (spaceService.isSuperManager(userIdentity.getRemoteId())) {
                    return true;
                }
                Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
                return spaceService.isMember(space, userIdentity.getRemoteId());
            }
            return false;
        });
    }

    public static TimeZone getICalTimeZone(ZoneId zoneId) {
        return ICAL4J_TIME_ZONE_REGISTRY.getTimeZone(zoneId.getId());
    }

    public static ZonedDateTime toDateTime(String dateTimeString, ZoneId userTimeZone) {
        long dateTimeMS = Long.parseLong(dateTimeString);
        ZonedDateTime dateTime = AgendaDateUtils.fromDate(new java.util.Date(dateTimeMS));
        return dateTime.withZoneSameLocal(ZoneOffset.UTC).withZoneSameInstant(userTimeZone);
    }

    private static /* synthetic */ void lambda$getICalendarRecur$5(WeekDayList list, String day) {
        list.add((Object)new WeekDay(day.toUpperCase()));
    }
}

