/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.dao;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.dao.EventAttachmentDAO;
import org.exoplatform.agenda.dao.EventAttendeeDAO;
import org.exoplatform.agenda.dao.EventConferenceDAO;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure1;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure3;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure5;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure7;
import org.exoplatform.agenda.dao.EventRecurrenceDAO;
import org.exoplatform.agenda.dao.EventReminderDAO;
import org.exoplatform.agenda.dao.RemoteEventDAO;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class EventDAO
extends GenericDAOJPAImpl<EventEntity, Long> {
    private EventConferenceDAO eventConferenceDAO;
    private EventAttendeeDAO eventAttendeeDAO;
    private EventAttachmentDAO eventAttachmentDAO;
    private EventReminderDAO eventReminderDAO;
    private EventRecurrenceDAO eventRecurrenceDAO;
    private RemoteEventDAO remoteEventDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public EventDAO(EventConferenceDAO eventConferenceDAO, EventAttendeeDAO eventAttendeeDAO, EventAttachmentDAO eventAttachmentDAO, EventReminderDAO eventReminderDAO, EventRecurrenceDAO eventRecurrenceDAO, RemoteEventDAO remoteEventDAO) {
        this.eventConferenceDAO = eventConferenceDAO;
        this.eventAttendeeDAO = eventAttendeeDAO;
        this.eventAttachmentDAO = eventAttachmentDAO;
        this.eventReminderDAO = eventReminderDAO;
        this.eventRecurrenceDAO = eventRecurrenceDAO;
        this.remoteEventDAO = remoteEventDAO;
    }

    @ExoTransactional
    public void delete(EventEntity entity) {
        EventEntity eventEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)eventEntity);
        Object[] objectArray = new Object[]{this, eventEntity, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new EventDAO$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void deleteCalendarEvents(long calendarId) {
        this.eventConferenceDAO.deleteCalendarConferences(calendarId);
        this.eventAttendeeDAO.deleteCalendarAttendees(calendarId);
        this.eventAttachmentDAO.deleteCalendarAttachments(calendarId);
        this.eventReminderDAO.deleteCalendarReminders(calendarId);
        this.eventRecurrenceDAO.deleteCalendarRecurrences(calendarId);
        this.remoteEventDAO.deleteCalendarRemoteEvents(calendarId);
        this.executeDeleteCalendarEventsQuery(calendarId);
    }

    public EventEntity deleteEvent(long eventId) {
        EventEntity eventEntity = (EventEntity)this.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            return null;
        }
        List<Long> childEventIds = this.getChildEvents(eventId);
        for (Long childEventId : childEventIds) {
            this.deleteEvent(childEventId);
        }
        this.eventConferenceDAO.deleteEventConferences(eventId);
        this.eventAttendeeDAO.deleteEventAttendees(eventId);
        this.eventAttachmentDAO.deleteEventAttachments(eventId);
        this.eventReminderDAO.deleteEventReminders(eventId);
        this.remoteEventDAO.deleteRemoteEvents(eventId);
        if (eventEntity.getRecurrence() != null) {
            this.eventRecurrenceDAO.delete(eventEntity.getRecurrence());
        }
        this.delete(eventEntity);
        return eventEntity;
    }

    @ExoTransactional
    public EventEntity create(EventEntity entity) {
        EventEntity eventEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)eventEntity);
        Object[] objectArray = new Object[]{this, eventEntity, joinPoint};
        return (EventEntity)ExoTransactionalAspect.aspectOf().around(new EventDAO$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public EventEntity update(EventEntity entity) {
        EventEntity eventEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)eventEntity);
        Object[] objectArray = new Object[]{this, eventEntity, joinPoint};
        return (EventEntity)ExoTransactionalAspect.aspectOf().around(new EventDAO$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    public void updateAll(List<EventEntity> entities) {
        throw new UnsupportedOperationException();
    }

    @ExoTransactional
    public void executeDeleteCalendarEventsQuery(long calendarId) {
        long l = calendarId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new EventDAO$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<Long> getEventIds(Date startDate, Date endDate, List<Long> ownerIds, List<Long> attendeeIds, List<EventAttendeeResponse> responseTypes, int limit) {
        List resultList;
        this.verifyLimit(endDate, limit);
        boolean filterAttendees = attendeeIds != null && !attendeeIds.isEmpty();
        boolean filterOwners = ownerIds != null && !ownerIds.isEmpty();
        StringBuilder jpql = new StringBuilder("SELECT DISTINCT(ev.id), ev.startDate FROM AgendaEvent ev");
        if (filterAttendees) {
            jpql.append(" INNER JOIN ev.attendees att");
        }
        jpql.append(" INNER JOIN ev.calendar cal");
        jpql.append(" WHERE ev.status = :status");
        jpql.append(" AND (ev.endDate IS NULL OR ev.endDate >= :start)");
        if (endDate != null) {
            jpql.append(" AND ev.startDate < :end");
        }
        if (filterOwners) {
            jpql.append(" AND cal.ownerId IN (:ownerIds)");
        }
        if (filterAttendees) {
            jpql.append(" AND att.identityId IN (:attendeeIds)");
            if (responseTypes != null) {
                jpql.append(" AND att.response IN (:responseTypes)");
            }
        }
        jpql.append(" ORDER BY ev.startDate DESC");
        TypedQuery query = this.getEntityManager().createQuery(jpql.toString(), Tuple.class);
        query.setParameter("start", (Object)startDate);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        if (endDate != null) {
            query.setParameter("end", (Object)endDate);
        }
        if (filterOwners) {
            query.setParameter("ownerIds", ownerIds);
        }
        if (filterAttendees) {
            query.setParameter("attendeeIds", attendeeIds);
            if (responseTypes != null) {
                query.setParameter("responseTypes", responseTypes);
            }
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public List<EventEntity> getParentRecurrentEventIds(Date startDate, Date endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getParentRecurrentEventIds", EventEntity.class);
        query.setParameter("start", (Object)startDate);
        query.setParameter("end", (Object)endDate);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<Long> getExceptionalOccurenceIdsByPeriod(long parentRecurrentEventId, Date startDate, Date endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getExceptionalOccurenceIdsByPeriod", Long.class);
        query.setParameter("parentEventId", (Object)parentRecurrentEventId);
        query.setParameter("start", (Object)startDate);
        query.setParameter("end", (Object)endDate);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<Long> getExceptionalOccurenceIds(long parentRecurrentEventId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getExceptionalOccurenceIds", Tuple.class);
        query.setParameter("parentEventId", (Object)parentRecurrentEventId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public void deleteExceptionalOccurences(long parentRecurrentEventId) {
        List<Long> result = this.getExceptionalOccurenceIds(parentRecurrentEventId);
        for (Long id : result) {
            this.deleteEvent(id);
        }
    }

    private List<Long> getChildEvents(long eventId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getChildEvents", Long.class);
        query.setParameter("parentEventId", (Object)eventId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    private void verifyLimit(Date endDate, int limit) {
        if (limit <= 0 && endDate == null) {
            throw new IllegalStateException("Limit of events to retrieve is missing, whether us endDate or limit parameters");
        }
    }

    static {
        EventDAO.ajc$preClinit();
    }

    static /* synthetic */ void delete_aroundBody0(EventDAO ajc$this, EventEntity entity, JoinPoint joinPoint) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is mandatory");
        }
        if (entity.getId() == null) {
            throw new IllegalArgumentException("Entity with valid identifier is mandatory");
        }
        ajc$this.eventConferenceDAO.deleteEventConferences(entity.getId());
        ajc$this.eventAttendeeDAO.deleteEventAttendees(entity.getId());
        ajc$this.eventAttachmentDAO.deleteEventAttachments(entity.getId());
        ajc$this.eventReminderDAO.deleteEventReminders(entity.getId());
        ajc$this.eventRecurrenceDAO.deleteEventRecurrences(entity.getId());
        ajc$this.remoteEventDAO.deleteRemoteEvents(entity.getId());
        super.delete((Object)entity);
    }

    static /* synthetic */ EventEntity create_aroundBody2(EventDAO ajc$this, EventEntity entity, JoinPoint joinPoint) {
        entity.setCreatedDate(new Date());
        return (EventEntity)super.create((Object)entity);
    }

    static /* synthetic */ EventEntity update_aroundBody4(EventDAO ajc$this, EventEntity entity, JoinPoint joinPoint) {
        entity.setUpdatedDate(new Date());
        return (EventEntity)super.update((Object)entity);
    }

    static /* synthetic */ void executeDeleteCalendarEventsQuery_aroundBody6(EventDAO ajc$this, long calendarId, JoinPoint joinPoint) {
        Query deleteEventsQuery = ajc$this.getEntityManager().createNamedQuery("AgendaEvent.deleteCalendarEvents");
        deleteEventsQuery.setParameter("calendarId", (Object)calendarId);
        deleteEventsQuery.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EventDAO.java", EventDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.exoplatform.agenda.dao.EventDAO", "org.exoplatform.agenda.entity.EventEntity", "entity", "", "void"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "org.exoplatform.agenda.dao.EventDAO", "org.exoplatform.agenda.entity.EventEntity", "entity", "", "org.exoplatform.agenda.entity.EventEntity"), 117);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.exoplatform.agenda.dao.EventDAO", "org.exoplatform.agenda.entity.EventEntity", "entity", "", "org.exoplatform.agenda.entity.EventEntity"), 124);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeDeleteCalendarEventsQuery", "org.exoplatform.agenda.dao.EventDAO", "long", "calendarId", "", "void"), 140);
    }
}

