/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.util.List;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.services.listener.ListenerService;

public class AgendaCalendarStorage {
    private ListenerService listenerService;
    private CalendarDAO calendarDAO;

    public AgendaCalendarStorage(CalendarDAO calendarDAO, ListenerService listenerService) {
        this.listenerService = listenerService;
        this.calendarDAO = calendarDAO;
    }

    public List<Long> getCalendarIdsByOwnerIds(int offset, int limit, Long ... ownerIds) {
        return this.calendarDAO.getCalendarIdsByOwnerIds(offset, limit, ownerIds);
    }

    public int countCalendarsByOwners(Long ... ownerIds) {
        return this.calendarDAO.countCalendarsByOwnerIds(ownerIds);
    }

    public Calendar getCalendarById(long calendarId) {
        CalendarEntity calendarEntity = (CalendarEntity)this.calendarDAO.find(Long.valueOf(calendarId));
        return EntityMapper.fromEntity(calendarEntity);
    }

    public Calendar createCalendar(Calendar calendar) {
        CalendarEntity calendarEntity = EntityMapper.toEntity(calendar);
        calendarEntity = this.calendarDAO.create(calendarEntity);
        Calendar createdCalendar = EntityMapper.fromEntity(calendarEntity);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.calendar.created", createdCalendar, null);
        return createdCalendar;
    }

    public void updateCalendar(Calendar calendar) {
        CalendarEntity calendarEntity = EntityMapper.toEntity(calendar);
        calendarEntity = this.calendarDAO.update(calendarEntity);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.calendar.updated", EntityMapper.fromEntity(calendarEntity), null);
    }

    public void deleteCalendarById(long calendarId) {
        CalendarEntity calendarEntity = (CalendarEntity)this.calendarDAO.find(Long.valueOf(calendarId));
        if (calendarEntity == null) {
            return;
        }
        this.calendarDAO.delete(calendarEntity);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.calendar.deleted", EntityMapper.fromEntity(calendarEntity), null);
    }
}

