/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.util;

import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.entity.IdentityEntity;

public class RestUtils {
    public static final int DEFAULT_LIMIT = 10;
    public static final int HARD_LIMIT = 50;

    private RestUtils() {
    }

    public static final String getCurrentUser() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    public static final Identity getCurrentUserIdentity(IdentityManager identityManager) {
        String currentUser = RestUtils.getCurrentUser();
        return identityManager.getOrCreateIdentity("organization", currentUser);
    }

    public static final long getCurrentUserIdentityId(IdentityManager identityManager) {
        String currentUser = RestUtils.getCurrentUser();
        Identity identity = identityManager.getOrCreateIdentity("organization", currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    public static String getBaseRestURI() {
        return RestUtils.getBasePortalURI() + "/" + PortalContainer.getCurrentRestContextName();
    }

    public static String getBasePortalURI() {
        return "/" + PortalContainer.getCurrentPortalContainerName();
    }

    public static String getIdentityId(IdentityEntity identityEntity, IdentityManager identityManager) {
        Identity identity;
        if (identityEntity == null) {
            return null;
        }
        String identityIdString = identityEntity.getId();
        String remoteId = identityEntity.getRemoteId();
        String providerId = identityEntity.getProviderId();
        if (StringUtils.isNotBlank((CharSequence)identityIdString) && (identity = identityManager.getIdentity(identityIdString)) == null) {
            identityIdString = null;
        }
        if (StringUtils.isBlank((CharSequence)identityIdString) && StringUtils.isNotBlank((CharSequence)remoteId) && StringUtils.isNotBlank((CharSequence)providerId) && (identity = identityManager.getOrCreateIdentity(providerId, remoteId)) != null) {
            identityIdString = identity.getId();
        }
        return identityIdString;
    }

    public static int getLimit(UriInfo uriInfo) {
        Integer limit = RestUtils.getIntegerValue(uriInfo, "limit");
        return limit != null && limit > 0 ? Math.min(50, limit) : 10;
    }

    public static int getOffset(UriInfo uriInfo) {
        Integer offset = RestUtils.getIntegerValue(uriInfo, "offset");
        return offset != null ? offset : 0;
    }

    public static Integer getIntegerValue(UriInfo uriInfo, String name) {
        String value = RestUtils.getQueryParam(uriInfo, name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getQueryParam(UriInfo uriInfo, String name) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)name);
    }
}

