/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class AgendaESListener
extends Listener<AgendaEventModification, Object> {
    private static final Log LOG = ExoLogger.getExoLogger(AgendaESListener.class);
    private final PortalContainer container;
    private final IndexingService indexingService;
    private AgendaEventService agendaEventService;

    public AgendaESListener(PortalContainer container, IndexingService indexingService) {
        this.container = container;
        this.indexingService = indexingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            if (this.indexingService != null) {
                AgendaEventModification eventModifications = (AgendaEventModification)event.getSource();
                long eventId = eventModifications.getEventId();
                org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId);
                if (agendaEvent == null) {
                    return;
                }
                if ("exo.agenda.event.created".equals(event.getEventName())) {
                    this.reindexAgendaEvent(eventId, "create agenda event");
                } else if ("exo.agenda.event.updated".equals(event.getEventName())) {
                    this.reindexAgendaEvent(eventId, "update agenda event");
                } else if ("exo.agenda.event.deleted".equals(event.getEventName())) {
                    this.unindexAgendaEvent(eventId, "delete agenda event");
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void reindexAgendaEvent(long eventId, String cause) {
        LOG.debug("Notifying indexing service for event with id={}. Cause: {}", new Object[]{eventId, cause});
        this.indexingService.reindex("event", String.valueOf(eventId));
    }

    private void unindexAgendaEvent(long eventId, String cause) {
        LOG.debug("Notifying unindexing service for event with id={}. Cause: {}", new Object[]{eventId, cause});
        this.indexingService.unindex("event", String.valueOf(eventId));
    }

    private AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

