/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.model.GuestUser;
import org.exoplatform.agenda.service.AgendaEventGuestService;
import org.exoplatform.agenda.storage.AgendaEventGuestStorage;

public class AgendaEventGuestServiceImpl
implements AgendaEventGuestService {
    private AgendaEventGuestStorage agendaEventGuestStorage;

    public AgendaEventGuestServiceImpl(AgendaEventGuestStorage agendaEventGuestStorage) {
        this.agendaEventGuestStorage = agendaEventGuestStorage;
    }

    public List<GuestUser> getEventGuests(long eventId) {
        return this.agendaEventGuestStorage.getEventGuests(eventId);
    }

    public void saveEventGuests(long eventId, List<GuestUser> guests) {
        List<GuestUser> oldGuests = this.getEventGuests(eventId);
        List<GuestUser> newGuests = guests == null ? Collections.emptyList() : guests;
        this.processGuestsToDelete(oldGuests, newGuests, eventId);
        this.processGuestsToCreate(oldGuests, newGuests, eventId);
    }

    public void deleteEventGuests(long eventId) {
        this.agendaEventGuestStorage.deleteEventGuests(eventId);
    }

    public boolean isGuest(String user, String guests, long eventId) {
        return guests.contains(user);
    }

    public void processGuestsToCreate(List<GuestUser> oldGuests, List<GuestUser> newGuests, Long eventId) {
        newGuests.stream().filter(guest -> !oldGuests.contains(guest)).forEach(guest -> this.agendaEventGuestStorage.saveEventGuestUser((GuestUser)guest, eventId));
    }

    public void processGuestsToDelete(List<GuestUser> oldGuests, List<GuestUser> newGuests, long eventId) {
        oldGuests.stream().filter(guest -> !newGuests.contains(guest)).forEach(guest -> this.agendaEventGuestStorage.deleteGuest(eventId, guest.getId()));
    }
}

