/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener.analytics;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class AgendaSavedEventListener
extends Listener<AgendaEventModification, Object> {
    private static final String EXO_AGENDA_EVENT_CREATED_EVENT_NAME = "exo.agenda.event.created";
    private static final String EVENT_UPDATED_OPERATION_NAME = "eventUpdated";
    private static final String EVENT_CREATED_OPERATION_NAME = "eventCreated";
    private AgendaCalendarService agendaCalendarService;
    private AgendaEventService agendaEventService;
    private IdentityManager identityManager;

    public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
        AgendaEventModification eventModification = (AgendaEventModification)event.getSource();
        Long eventId = eventModification.getEventId();
        org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId.longValue());
        boolean isNew = StringUtils.equals((CharSequence)event.getEventName(), (CharSequence)EXO_AGENDA_EVENT_CREATED_EVENT_NAME);
        long userId = isNew ? agendaEvent.getCreatorId() : agendaEvent.getModifierId();
        this.addEventStatistic(agendaEvent, eventModification, userId, isNew);
    }

    private void addEventStatistic(org.exoplatform.agenda.model.Event event, AgendaEventModification eventModification, long userId, boolean isNew) {
        String operation = isNew ? EVENT_CREATED_OPERATION_NAME : EVENT_UPDATED_OPERATION_NAME;
        Calendar calendar = this.getAgendaCalendarService().getCalendarById(event.getCalendarId());
        long calendarOwnerId = calendar.getOwnerId();
        Identity spaceOwnerIdentity = this.getIdentityManager().getIdentity(String.valueOf(calendar.getOwnerId()));
        StatisticData statisticData = new StatisticData();
        if (StringUtils.equals((CharSequence)spaceOwnerIdentity.getProviderId(), (CharSequence)"space")) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByPrettyName(spaceOwnerIdentity.getRemoteId());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        } else {
            userId = calendarOwnerId;
        }
        statisticData.setModule("agenda");
        statisticData.setSubModule("event");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        statisticData.addParameter("eventId", (Object)event.getId());
        statisticData.addParameter("parentId", (Object)event.getParentId());
        statisticData.addParameter("calendarOwnerIdentityId", (Object)calendarOwnerId);
        statisticData.addParameter("creatorId", (Object)event.getCreatorId());
        statisticData.addParameter("modifierId", (Object)event.getModifierId());
        statisticData.addParameter("eventStatus", (Object)event.getStatus());
        statisticData.addParameter("isRecurrent", (Object)(event.getRecurrence() != null ? 1 : 0));
        statisticData.addParameter("isExceptionalOccurrence", (Object)(event.getOccurrence() != null ? 1 : 0));
        statisticData.addParameter("eventModificationTypes", (Object)eventModification.getModificationTypes());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    public AgendaCalendarService getAgendaCalendarService() {
        if (this.agendaCalendarService == null) {
            this.agendaCalendarService = (AgendaCalendarService)ExoContainerContext.getService(AgendaCalendarService.class);
        }
        return this.agendaCalendarService;
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }
}

