/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.dao.EventDateOptionDAO;
import org.exoplatform.agenda.dao.EventDatePollDAO;
import org.exoplatform.agenda.dao.EventDateVoteDAO;
import org.exoplatform.agenda.entity.EventDateOptionEntity;
import org.exoplatform.agenda.entity.EventDatePollEntity;
import org.exoplatform.agenda.entity.EventDateVoteEntity;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class AgendaEventDatePollStorage {
    private EventDatePollDAO datePollDAO;
    private EventDateOptionDAO dateOptionDAO;
    private EventDateVoteDAO dateVoteDAO;

    public AgendaEventDatePollStorage(EventDateOptionDAO dateOptionDAO, EventDatePollDAO datePollDAO, EventDateVoteDAO dateVoteDAO) {
        this.datePollDAO = datePollDAO;
        this.dateOptionDAO = dateOptionDAO;
        this.dateVoteDAO = dateVoteDAO;
    }

    public List<EventDateOption> getEventDateOptions(long eventId) {
        List<EventDateOptionEntity> dateOptionEntities = this.dateOptionDAO.findDateOptionsByEventId(eventId);
        if (dateOptionEntities == null || dateOptionEntities.isEmpty()) {
            return Collections.emptyList();
        }
        EventDatePollEntity datePollEntity = this.datePollDAO.findDatePollByEventId(eventId);
        Long selectedDateOptionId = datePollEntity == null || datePollEntity.getSelectedDateOptionId() == null ? 0L : datePollEntity.getSelectedDateOptionId();
        ArrayList<EventDateOption> dateOptions = new ArrayList<EventDateOption>();
        for (EventDateOptionEntity eventDateOptionEntity : dateOptionEntities) {
            ZonedDateTime startDate = AgendaDateUtils.fromDate(eventDateOptionEntity.getStartDate());
            ZonedDateTime endDate = AgendaDateUtils.fromDate(eventDateOptionEntity.getEndDate());
            Long dateOptionId = eventDateOptionEntity.getId();
            List<EventDateVoteEntity> dateVoteEntities = this.dateVoteDAO.findVotersByDateOptionId(dateOptionId);
            List voters = dateVoteEntities.stream().map(dateVoteEntity -> dateVoteEntity.getIdentityId()).collect(Collectors.toList());
            EventDateOption dateOption = new EventDateOption(dateOptionId.longValue(), eventDateOptionEntity.getEventId().longValue(), startDate, endDate, eventDateOptionEntity.isAllDay(), selectedDateOptionId == dateOptionId, voters);
            dateOptions.add(dateOption);
        }
        return dateOptions;
    }

    public EventDateOption createDateOption(EventDateOption dateOption) {
        EventDateOptionEntity dateOptionEntity = new EventDateOptionEntity();
        dateOptionEntity.setId(null);
        dateOptionEntity.setAllDay(dateOption.isAllDay());
        dateOptionEntity.setEventId(dateOption.getEventId());
        ZonedDateTime start = dateOption.getStart();
        ZonedDateTime end = dateOption.getEnd();
        if (dateOption.isAllDay()) {
            start = start.toLocalDate().atStartOfDay(ZoneOffset.UTC);
            end = end.toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L);
        } else {
            start = start.withZoneSameInstant(ZoneOffset.UTC);
            end = end.withZoneSameInstant(ZoneOffset.UTC);
        }
        dateOptionEntity.setStartDate(AgendaDateUtils.toDate(start));
        dateOptionEntity.setEndDate(AgendaDateUtils.toDate(end));
        dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.create(dateOptionEntity);
        return new EventDateOption(dateOptionEntity.getId().longValue(), dateOptionEntity.getEventId().longValue(), AgendaDateUtils.fromDate(dateOptionEntity.getStartDate()), AgendaDateUtils.fromDate(dateOptionEntity.getEndDate()), dateOptionEntity.isAllDay(), false, null);
    }

    public void selectDateOption(long dateOptionId) throws ObjectNotFoundException {
        EventDateOptionEntity dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.find(Long.valueOf(dateOptionId));
        if (dateOptionEntity == null) {
            throw new ObjectNotFoundException("Date Option with id " + dateOptionId + " is not found");
        }
        Long eventId = dateOptionEntity.getEventId();
        EventDatePollEntity datePollEntity = this.datePollDAO.findDatePollByEventId(eventId);
        if (datePollEntity == null) {
            datePollEntity = new EventDatePollEntity();
            datePollEntity.setEventId(eventId);
            datePollEntity.setId(null);
            datePollEntity.setSelectedDateOptionId(dateOptionId);
            this.datePollDAO.create(datePollEntity);
        } else {
            datePollEntity.setSelectedDateOptionId(dateOptionId);
            this.datePollDAO.update(datePollEntity);
        }
    }

    public void deleteEventVotes(long eventId) {
        List<EventDateOptionEntity> dateOptionEntities = this.dateOptionDAO.findDateOptionsByEventId(eventId);
        if (dateOptionEntities != null && !dateOptionEntities.isEmpty()) {
            List<Long> eventDateOptionIds = dateOptionEntities.stream().map(EventDateOptionEntity::getId).collect(Collectors.toList());
            this.dateVoteDAO.deleteDateOptionsVotes(eventDateOptionIds);
        }
    }

    public void updateDateOption(EventDateOption dateOption) throws ObjectNotFoundException {
        long dateOptionId = dateOption.getId();
        EventDateOptionEntity dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.find(Long.valueOf(dateOptionId));
        if (dateOptionEntity == null) {
            throw new ObjectNotFoundException("Date Option with id " + dateOptionId + " is not found");
        }
        dateOptionEntity.setAllDay(dateOption.isAllDay());
        dateOptionEntity.setEventId(dateOption.getEventId());
        ZonedDateTime start = dateOption.getStart();
        ZonedDateTime end = dateOption.getEnd();
        if (dateOption.isAllDay()) {
            start = start.toLocalDate().atStartOfDay(ZoneOffset.UTC);
            end = end.toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L);
        } else {
            start = start.withZoneSameInstant(ZoneOffset.UTC);
            end = end.withZoneSameInstant(ZoneOffset.UTC);
        }
        dateOptionEntity.setStartDate(AgendaDateUtils.toDate(start));
        dateOptionEntity.setEndDate(AgendaDateUtils.toDate(end));
        this.dateOptionDAO.update(dateOptionEntity);
    }

    public void deleteDateOption(EventDateOption dateOption) {
        EventDateOptionEntity dateOptionEntity;
        EventDatePollEntity datePollEntity;
        if (dateOption.isSelected() && (datePollEntity = this.datePollDAO.findDatePollByEventId(dateOption.getEventId())) != null && datePollEntity.getSelectedDateOptionId().longValue() == dateOption.getId()) {
            datePollEntity.setSelectedDateOptionId(null);
            this.datePollDAO.update(datePollEntity);
        }
        if ((dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.find(Long.valueOf(dateOption.getId()))) != null) {
            this.dateOptionDAO.delete(dateOptionEntity);
        }
    }

    public EventDateOption getDateOption(long dateOptionId, boolean withVoters, boolean withSelection) {
        EventDateOptionEntity dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.find(Long.valueOf(dateOptionId));
        if (dateOptionEntity == null) {
            return null;
        }
        EventDatePollEntity datePollEntity = withSelection ? this.datePollDAO.findDatePollByEventId(dateOptionEntity.getEventId()) : null;
        Long selectedDateOptionId = datePollEntity == null || datePollEntity.getSelectedDateOptionId() == null ? 0L : datePollEntity.getSelectedDateOptionId();
        ZonedDateTime startDate = AgendaDateUtils.fromDate(dateOptionEntity.getStartDate());
        ZonedDateTime endDate = AgendaDateUtils.fromDate(dateOptionEntity.getEndDate());
        List dateVoteEntities = withVoters ? this.dateVoteDAO.findVotersByDateOptionId(dateOptionId) : Collections.emptyList();
        List voters = dateVoteEntities.stream().map(dateVoteEntity -> dateVoteEntity.getIdentityId()).collect(Collectors.toList());
        return new EventDateOption(dateOptionId, dateOptionEntity.getEventId().longValue(), startDate, endDate, dateOptionEntity.isAllDay(), selectedDateOptionId == dateOptionId, voters);
    }

    public void vote(long dateOptionId, long identityId) throws ObjectNotFoundException {
        EventDateOptionEntity dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.find(Long.valueOf(dateOptionId));
        if (dateOptionEntity == null) {
            throw new ObjectNotFoundException("Date Option with id " + dateOptionId + " is not found");
        }
        EventDateVoteEntity dateVoteEntity = this.dateVoteDAO.findVoteByOptionAndIdentity(dateOptionId, identityId);
        if (dateVoteEntity != null) {
            return;
        }
        dateVoteEntity = new EventDateVoteEntity();
        dateVoteEntity.setDateOptionId(dateOptionId);
        dateVoteEntity.setIdentityId(identityId);
        this.dateVoteDAO.create(dateVoteEntity);
    }

    public void dismiss(long dateOptionId, long identityId) throws ObjectNotFoundException {
        EventDateOptionEntity dateOptionEntity = (EventDateOptionEntity)this.dateOptionDAO.find(Long.valueOf(dateOptionId));
        if (dateOptionEntity == null) {
            throw new ObjectNotFoundException("Date Option with id " + dateOptionId + " is not found");
        }
        EventDateVoteEntity dateVoteEntity = this.dateVoteDAO.findVoteByOptionAndIdentity(dateOptionId, identityId);
        if (dateVoteEntity == null) {
            return;
        }
        this.dateVoteDAO.delete(dateVoteEntity);
    }
}

