/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.constant.EventRecurrenceType;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventAttendeeServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testGetEventAttendees() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser5Identity);
        long eventId = event.getId();
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)1L, (long)eventAttendees.size());
        EventAttendee eventAttendeeToStore = (EventAttendee)ATTENDEES.get(0);
        EventAttendee eventAttendee = (EventAttendee)eventAttendees.get(0);
        Assert.assertNotNull((Object)eventAttendee);
        Assert.assertTrue((eventAttendee.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)eventAttendeeToStore.getIdentityId(), (long)eventAttendee.getIdentityId());
        Assert.assertEquals((Object)EventAttendeeResponse.NEEDS_ACTION, (Object)eventAttendee.getResponse());
    }

    @Test
    public void testGetEventAttendeesByResponses() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        long creatorId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event.clone(), creatorId, this.testuser1Identity, this.testuser5Identity, this.spaceIdentity);
        long eventId = event.getId();
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId, new EventAttendeeResponse[]{EventAttendeeResponse.ACCEPTED}).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)1L, (long)eventAttendees.size());
        EventAttendee eventAttendee = (EventAttendee)eventAttendees.get(0);
        Assert.assertNotNull((Object)eventAttendee);
        Assert.assertTrue((eventAttendee.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)creatorId, (long)eventAttendee.getIdentityId());
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)eventAttendee.getResponse());
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser5Identity.getId()), EventAttendeeResponse.ACCEPTED);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.TENTATIVE);
        eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId, new EventAttendeeResponse[]{EventAttendeeResponse.ACCEPTED}).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)2L, (long)eventAttendees.size());
        eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId, new EventAttendeeResponse[]{EventAttendeeResponse.ACCEPTED, EventAttendeeResponse.TENTATIVE}).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)3L, (long)eventAttendees.size());
    }

    @Test
    public void testGetEventResponse() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event.setStatus(EventStatus.CONFIRMED);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser5Identity);
        long eventId = event.getId();
        try {
            this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail((String)"should throw an exception, user is not attendee of the event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.getEventResponse(5000L, null, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"should throw an exception, event id doesn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        EventAttendeeResponse eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((String)"Creator should accept event just after creating the event", (Object)EventAttendeeResponse.ACCEPTED, (Object)eventResponse);
        eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((String)"Invitee default response should be empty just after creating the event", (Object)EventAttendeeResponse.NEEDS_ACTION, (Object)eventResponse);
    }

    @Test
    public void testSendEventResponse() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event.setStatus(EventStatus.CONFIRMED);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser5Identity);
        long eventId = event.getId();
        try {
            this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser1Identity.getId()), null);
            Assert.fail((String)"should throw an exception, response shouldn't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendEventResponse(5000L, Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.ACCEPTED);
            Assert.fail((String)"should throw an exception, event with id doesn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendEventResponse(0L, Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.ACCEPTED);
            Assert.fail((String)"should throw an exception, event with id doesn't exists");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.DECLINED);
        EventAttendeeResponse eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.DECLINED, (Object)eventResponse);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser5Identity.getId()), EventAttendeeResponse.TENTATIVE);
        eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)eventResponse);
    }

    @Test
    public void testSaveRecurrentEventAttendees() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, start.plusDays(2L).toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        long eventId = event.getId();
        Event exceptionalOccurrence = this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(1L));
        Assert.assertNotNull((Object)exceptionalOccurrence);
        long exceptionalOccurrenceId = exceptionalOccurrence.getId();
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        EventAttendeeResponse eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, userIdentityId);
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)eventResponse);
        EventAttendeeResponse exceptionalOccurrenceResponse = this.agendaEventAttendeeService.getEventResponse(exceptionalOccurrenceId, null, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)exceptionalOccurrenceResponse);
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.DECLINED);
        eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, userIdentityId);
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.DECLINED, (Object)eventResponse);
        exceptionalOccurrenceResponse = this.agendaEventAttendeeService.getEventResponse(exceptionalOccurrenceId, null, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.DECLINED, (Object)exceptionalOccurrenceResponse);
        this.agendaEventAttendeeService.sendEventResponse(exceptionalOccurrenceId, userIdentityId, EventAttendeeResponse.TENTATIVE);
        eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, userIdentityId);
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.DECLINED, (Object)eventResponse);
        exceptionalOccurrenceResponse = this.agendaEventAttendeeService.getEventResponse(exceptionalOccurrenceId, null, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)exceptionalOccurrenceResponse);
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.ACCEPTED);
        eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, userIdentityId);
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)eventResponse);
        exceptionalOccurrenceResponse = this.agendaEventAttendeeService.getEventResponse(exceptionalOccurrenceId, null, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)exceptionalOccurrenceResponse);
    }

    @Test
    public void testSaveEventAttendees() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser5Identity);
        long eventId = event.getId();
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)1L, (long)eventAttendees.size());
        EventAttendee eventAttendee = (EventAttendee)eventAttendees.get(0);
        eventAttendee = eventAttendee.clone();
        eventAttendee.setId(0L);
        eventAttendees.add(eventAttendee);
        long userIdentityId = Long.parseLong(this.testuser5Identity.getId());
        this.agendaEventAttendeeService.saveEventAttendees(event, eventAttendees, userIdentityId, true, true, new AgendaEventModification(event.getId(), event.getCalendarId(), userIdentityId, Collections.singleton(AgendaEventModificationType.ADDED)));
        eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((String)"Same user was added twice, only one attendee object should remain in store", (long)1L, (long)eventAttendees.size());
        eventAttendee = eventAttendee.clone();
        eventAttendee.setId(0L);
        eventAttendee.setIdentityId(Long.parseLong(this.testuser4Identity.getId()));
        eventAttendees.add(eventAttendee);
        this.agendaEventAttendeeService.saveEventAttendees(event, eventAttendees, userIdentityId, true, true, new AgendaEventModification(event.getId(), event.getCalendarId(), userIdentityId, Collections.singleton(AgendaEventModificationType.ADDED)));
        eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)2L, (long)eventAttendees.size());
        this.agendaEventAttendeeService.saveEventAttendees(event, Collections.emptyList(), userIdentityId, true, true, new AgendaEventModification(event.getId(), event.getCalendarId(), userIdentityId, Collections.singleton(AgendaEventModificationType.ADDED)));
        eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)0L, (long)eventAttendees.size());
    }

    @Test
    public void testSendUpcomingEventResponse() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event.setStatus(EventStatus.CONFIRMED);
        event.setRecurrence(new EventRecurrence(0L, null, 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null));
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser5Identity);
        long eventId = event.getId();
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser5Identity.getId()), EventAttendeeResponse.ACCEPTED);
        EventAttendeeResponse eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertNotNull((Object)eventResponse);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)eventResponse);
        List eventOccurrences = this.agendaEventService.getEventOccurrencesInPeriod(event, start, start.plusDays(10L), (ZoneId)ZoneOffset.UTC, 0);
        Assert.assertNotNull((Object)eventOccurrences);
        Assert.assertEquals((long)11L, (long)eventOccurrences.size());
        try {
            this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser1Identity.getId()), null);
            Assert.fail((String)"should throw an exception, response shouldn't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendUpcomingEventResponse(0L, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.TENTATIVE);
            Assert.fail((String)"should throw an exception, event with id doesn't exists");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), 0L, EventAttendeeResponse.TENTATIVE);
            Assert.fail((String)"should throw an exception, occurrence id doesn't exists");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), 2222L, EventAttendeeResponse.TENTATIVE);
            Assert.fail((String)"should throw an exception, identity id doesn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendUpcomingEventResponse(5000L, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.TENTATIVE);
            Assert.fail((String)"should throw an exception, event with id doesn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.TENTATIVE);
            Assert.fail((String)"should throw an exception, user testuser3 isn't an attendee");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId()), EventAttendeeResponse.TENTATIVE);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(0)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(1)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(2)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(4)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(9)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, ((Event)eventOccurrences.get(5)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId()), EventAttendeeResponse.DECLINED);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(0)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(1)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(2)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(3)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(4)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.DECLINED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(5)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        Assert.assertEquals((Object)EventAttendeeResponse.DECLINED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(9)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser5Identity.getId()), EventAttendeeResponse.ACCEPTED);
        Assert.assertEquals((Object)EventAttendeeResponse.ACCEPTED, (Object)this.agendaEventAttendeeService.getEventResponse(eventId, ((Event)eventOccurrences.get(9)).getOccurrence().getId(), Long.parseLong(this.testuser5Identity.getId())));
    }
}

