/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventConferenceServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testSaveEventConferences() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        long eventId = event.getId();
        List eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertNotNull((Object)eventConferences);
        Assert.assertEquals((long)1L, (long)eventConferences.size());
        EventConference eventConferenceToStore = (EventConference)CONFERENCES.get(0);
        EventConference eventConference = (EventConference)eventConferences.get(0);
        Assert.assertNotNull((Object)eventConference);
        Assert.assertTrue((eventConference.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)eventConferenceToStore.getAccessCode(), (Object)eventConference.getAccessCode());
        Assert.assertEquals((Object)eventConferenceToStore.getDescription(), (Object)eventConference.getDescription());
        Assert.assertEquals((long)eventConferenceToStore.getEventId(), (long)eventConference.getEventId());
        Assert.assertEquals((Object)eventConferenceToStore.getPhone(), (Object)eventConference.getPhone());
        Assert.assertEquals((Object)eventConferenceToStore.getType(), (Object)eventConference.getType());
        Assert.assertEquals((Object)eventConferenceToStore.getUrl(), (Object)eventConference.getUrl());
        eventConference = new EventConference(0L, 0L, "type", "uri", "phone", "accessCode", "description");
        eventConferences.add(eventConference);
        this.agendaEventConferenceService.saveEventConferences(eventId, eventConferences);
        eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertEquals((long)2L, (long)eventConferences.size());
        this.agendaEventConferenceService.saveEventConferences(eventId, Collections.emptyList());
        eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertEquals((long)0L, (long)eventConferences.size());
    }

    @Test
    public void testGetEventConferences() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        long eventId = event.getId();
        List eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertNotNull((Object)eventConferences);
        Assert.assertEquals((long)1L, (long)eventConferences.size());
        EventConference eventConferenceToStore = (EventConference)CONFERENCES.get(0);
        EventConference eventConference = (EventConference)eventConferences.get(0);
        Assert.assertNotNull((Object)eventConference);
        Assert.assertTrue((eventConference.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)eventConferenceToStore.getAccessCode(), (Object)eventConference.getAccessCode());
        Assert.assertEquals((Object)eventConferenceToStore.getDescription(), (Object)eventConference.getDescription());
        Assert.assertEquals((long)eventConferenceToStore.getEventId(), (long)eventConference.getEventId());
        Assert.assertEquals((Object)eventConferenceToStore.getPhone(), (Object)eventConference.getPhone());
        Assert.assertEquals((Object)eventConferenceToStore.getType(), (Object)eventConference.getType());
        Assert.assertEquals((Object)eventConferenceToStore.getUrl(), (Object)eventConference.getUrl());
    }
}

