/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service.notification.plugin;

import java.time.ZonedDateTime;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.notification.plugin.DatePollNotificationPlugin;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.junit.Assert;
import org.junit.Test;

public class DatePollNotificationPluginTest
extends BaseAgendaEventTest {
    public static final ArgumentLiteral<String> EVENT_TITLE = new ArgumentLiteral(String.class, "eventTitle");

    @Test
    public void testMakeNotificationWhenSuggestDates() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        Event event = this.newEventInstance(start, start, false);
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity, this.testuser3Identity, this.spaceIdentity);
        InitParams initParams = new InitParams();
        ValueParam value = new ValueParam();
        value.setName("DatePollNotificationPlugin");
        value.setValue("#111111");
        initParams.addParam((Object)value);
        value.setName("agenda.notification.plugin.key");
        value.setValue("111");
        initParams.addParam((Object)value);
        DatePollNotificationPlugin datePollNotificationPlugin = new DatePollNotificationPlugin(initParams, this.identityManager, this.agendaCalendarService, this.spaceService);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)createdEvent).append(NotificationUtils.EVENT_ATTENDEE, (Object)this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).getEventAttendees()).append(EVENT_TITLE, (Object)createdEvent.getSummary()).append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.ADDED.name());
        long nbAttendee = this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).size();
        long ownerId = this.agendaCalendarService.getCalendarById(createdEvent.getCalendarId()).getOwnerId();
        String creatorName = this.identityManager.getIdentity(String.valueOf(createdEvent.getCreatorId())).getProfile().getFullName();
        NotificationInfo notificationInfo = datePollNotificationPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)String.valueOf(createdEvent.getId()), (Object)notificationInfo.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)String.valueOf(ownerId), (Object)notificationInfo.getValueOwnerParameter("ownerId"));
        Assert.assertEquals((Object)createdEvent.getSummary(), (Object)notificationInfo.getValueOwnerParameter("eventTitle"));
        Assert.assertEquals((Object)creatorName, (Object)notificationInfo.getValueOwnerParameter("eventCreator"));
        Assert.assertEquals((long)(nbAttendee - 1L), (long)notificationInfo.getSendToUserIds().size());
    }
}

