/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.search;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.search.AgendaIndexingServiceConnector;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.junit.Assert;
import org.junit.Test;

public class AgendaIndexingServiceConnectorTest
extends BaseAgendaEventTest {
    AgendaEventAttendeeService attendeeService = null;
    AgendaIndexingServiceConnector agendaIndexingServiceConnector = null;

    @Override
    public void setUp() throws ObjectNotFoundException {
        super.setUp();
        this.attendeeService = (AgendaEventAttendeeService)this.container.getComponentInstanceOfType(AgendaEventAttendeeService.class);
        this.agendaIndexingServiceConnector = new AgendaIndexingServiceConnector(this.agendaCalendarService, this.agendaEventService, this.attendeeService, this.getParams());
    }

    @Test
    public void testGetAllIds() {
        try {
            this.agendaIndexingServiceConnector.getAllIds(0, 10);
            Assert.fail((String)"getAllIds shouldn't be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetType() {
        this.agendaIndexingServiceConnector = new AgendaIndexingServiceConnector(this.agendaCalendarService, this.agendaEventService, this.attendeeService, this.getParams());
        Assert.assertEquals((Object)"event", (Object)this.agendaIndexingServiceConnector.getConnectorName());
    }

    @Test
    public void testCreate() throws Exception {
        this.agendaIndexingServiceConnector = new AgendaIndexingServiceConnector(this.agendaCalendarService, this.agendaEventService, this.attendeeService, this.getParams());
        try {
            this.agendaIndexingServiceConnector.create(null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaIndexingServiceConnector.create("1");
            Assert.fail((String)"IllegalStateException should be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        Event event = this.newEventInstance(start, start, false);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        Document document = this.agendaIndexingServiceConnector.create(String.valueOf(event.getId()));
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)String.valueOf(event.getId()), (Object)document.getId());
        Assert.assertEquals((Object)String.valueOf(event.getId()), document.getFields().get("id"));
        Assert.assertEquals((Object)String.valueOf(this.calendar.getOwnerId()), document.getFields().get("ownerId"));
        Assert.assertEquals((Object)String.valueOf(this.calendar.getId()), document.getFields().get("calendarId"));
        Assert.assertEquals((Object)event.getSummary(), document.getFields().get("summary"));
        Assert.assertEquals((Object)event.getDescription(), document.getFields().get("description"));
        Assert.assertEquals((Object)event.getLocation(), document.getFields().get("location"));
        long eventStartTimeInMS = event.getStart().toInstant().toEpochMilli();
        long eventEndTimeInMS = event.getEnd().toInstant().toEpochMilli();
        Assert.assertEquals((Object)Long.toString(eventStartTimeInMS), document.getFields().get("startTime"));
        Assert.assertEquals((Object)Long.toString(eventEndTimeInMS), document.getFields().get("endTime"));
    }

    @Test
    public void testUpdate() throws Exception {
        this.agendaIndexingServiceConnector = new AgendaIndexingServiceConnector(this.agendaCalendarService, this.agendaEventService, this.attendeeService, this.getParams());
        try {
            this.agendaIndexingServiceConnector.update(null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaIndexingServiceConnector.update("1");
            Assert.fail((String)"IllegalStateException should be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        Event event = this.newEventInstance(start, start, false);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        Document document = this.agendaIndexingServiceConnector.update(String.valueOf(event.getId()));
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)String.valueOf(event.getId()), (Object)document.getId());
        Assert.assertEquals((Object)String.valueOf(event.getId()), document.getFields().get("id"));
        Assert.assertEquals((Object)String.valueOf(this.calendar.getOwnerId()), document.getFields().get("ownerId"));
        Assert.assertEquals((Object)String.valueOf(this.calendar.getId()), document.getFields().get("calendarId"));
        Assert.assertEquals((Object)event.getSummary(), document.getFields().get("summary"));
        Assert.assertEquals((Object)event.getDescription(), document.getFields().get("description"));
        Assert.assertEquals((Object)event.getLocation(), document.getFields().get("location"));
        long eventStartTimeInMS = event.getStart().withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli();
        long eventEndTimeInMS = event.getEnd().withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli();
        Assert.assertEquals((Object)Long.toString(eventStartTimeInMS), document.getFields().get("startTime"));
        Assert.assertEquals((Object)Long.toString(eventEndTimeInMS), document.getFields().get("endTime"));
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        params.addParameter((Parameter)propertiesParam);
        propertiesParam.setProperty("index_current", "index_name");
        return params;
    }
}

