/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.dao;

import java.io.Serializable;
import java.util.Date;
import junit.framework.TestCase;
import org.exoplatform.agenda.constant.EventAvailability;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.naming.InitialContextInitializer;

public class EventDAOTest
extends TestCase {
    private EventAvailability availability = EventAvailability.BUSY;
    private boolean allDay = true;
    private String color = "Color";
    private String location = "Location";
    private String description = "Description";
    private String summary = "Summary";
    private Date occurrenceId = new Date();
    private EventStatus status = EventStatus.TENTATIVE;
    private long creatorId = 2L;
    private Date startDate = new Date(System.currentTimeMillis() - 86400000L);
    private Date endDate = new Date(System.currentTimeMillis());
    private PortalContainer container;
    private EventDAO eventDAO;
    private CalendarDAO calendarDAO;

    protected void setUp() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        this.container = PortalContainer.getInstance();
        this.eventDAO = (EventDAO)this.container.getComponentInstanceOfType(EventDAO.class);
        this.calendarDAO = (CalendarDAO)this.container.getComponentInstanceOfType(CalendarDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    private void end() {
        RequestLifeCycle.end();
    }

    public void testCreateEvent() {
        CalendarEntity calendarEntity = this.newCalendar();
        try {
            EventEntity eventEntity = this.newEvent(calendarEntity);
            EventDAOTest.assertNotNull((Object)eventEntity);
            EventDAOTest.assertNotNull((Object)eventEntity.getId());
            EventDAOTest.assertEquals((Object)this.availability, (Object)eventEntity.getAvailability());
            EventDAOTest.assertEquals((boolean)this.allDay, (boolean)eventEntity.isAllDay());
            EventDAOTest.assertEquals((String)this.color, (String)eventEntity.getColor());
            EventDAOTest.assertEquals((String)this.location, (String)eventEntity.getLocation());
            EventDAOTest.assertEquals((String)this.description, (String)eventEntity.getDescription());
            EventDAOTest.assertEquals((String)this.summary, (String)eventEntity.getSummary());
            EventDAOTest.assertEquals((Object)this.occurrenceId, (Object)eventEntity.getOccurrenceId());
            EventDAOTest.assertEquals((Object)this.status, (Object)eventEntity.getStatus());
            EventDAOTest.assertEquals((long)this.creatorId, (long)eventEntity.getCreatorId());
            EventDAOTest.assertEquals((Object)this.startDate, (Object)eventEntity.getStartDate());
            EventDAOTest.assertEquals((Object)this.endDate, (Object)eventEntity.getEndDate());
        }
        finally {
            this.eventDAO.deleteCalendarEvents(calendarEntity.getId().longValue());
            this.calendarDAO.delete(calendarEntity);
        }
    }

    public void testDeleteEvent() {
        CalendarEntity calendarEntity = this.newCalendar();
        try {
            EventEntity eventEntity = this.newEvent(calendarEntity);
            EventDAOTest.assertNotNull((Object)eventEntity.getId());
            this.eventDAO.delete(eventEntity);
            eventEntity = (EventEntity)this.eventDAO.find((Serializable)eventEntity.getId());
            EventDAOTest.assertNull((Object)eventEntity);
        }
        finally {
            this.eventDAO.deleteCalendarEvents(calendarEntity.getId().longValue());
            this.calendarDAO.delete(calendarEntity);
        }
    }

    private EventEntity newEvent(CalendarEntity calendarEntity) {
        return this.newEvent(calendarEntity, this.availability, this.allDay, this.color, this.location, this.description, this.summary, this.occurrenceId, this.status, this.creatorId, this.startDate, this.endDate);
    }

    private EventEntity newEvent(CalendarEntity calendarEntity, EventAvailability availability, boolean allDay, String color, String location, String description, String summary, Date occurrenceId, EventStatus status, long creatorId, Date startDate, Date endDate) {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setAllDay(allDay);
        eventEntity.setAvailability(availability);
        eventEntity.setCalendar(calendarEntity);
        eventEntity.setColor(color);
        eventEntity.setDescription(description);
        eventEntity.setCreatorId(creatorId);
        eventEntity.setEndDate(endDate);
        eventEntity.setStartDate(startDate);
        eventEntity.setLocation(location);
        eventEntity.setOccurrenceId(occurrenceId);
        eventEntity.setStatus(status);
        eventEntity.setSummary(summary);
        return this.eventDAO.create(eventEntity);
    }

    private CalendarEntity newCalendar() {
        CalendarEntity calendarEntity = new CalendarEntity();
        String calendarColor = "Color";
        String calendarDescription = "Description";
        long ownerId = 2L;
        boolean isSystem = true;
        calendarEntity.setColor(calendarColor);
        calendarEntity.setDescription(calendarDescription);
        calendarEntity.setOwnerId(Long.valueOf(ownerId));
        calendarEntity.setSystem(isSystem);
        calendarEntity = this.calendarDAO.create(calendarEntity);
        return calendarEntity;
    }

    private void begin() {
        RequestLifeCycle.begin((ExoContainer)this.container);
    }
}

