/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.agenda.listener.AgendaEventReminderListener;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventReminderParameter;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventReminderListenerTest
extends BaseAgendaEventTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserReminders() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        org.exoplatform.agenda.model.Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser4Identity, this.testuser5Identity);
        long eventId = event.getId();
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        final AtomicBoolean executeListener = new AtomicBoolean(true);
        this.listenerService.addListener("exo.agenda.event.responseSaved", (Listener)new Listener<EventAttendee, EventAttendee>(){

            public void onEvent(Event<EventAttendee, EventAttendee> event) throws Exception {
                if (executeListener.get()) {
                    new AgendaEventReminderListener().onEvent(event);
                }
            }
        });
        long user5IdentityId = Long.parseLong(this.testuser5Identity.getId());
        try {
            this.agendaEventAttendeeService.sendEventResponse(eventId, user5IdentityId, EventAttendeeResponse.ACCEPTED);
        }
        finally {
            executeListener.set(false);
        }
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, user5IdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)this.agendaUserSettingsService.getDefaultReminders().size(), (long)eventReminders.size());
        executeListener.set(true);
        try {
            this.agendaEventAttendeeService.sendEventResponse(eventId, user5IdentityId, EventAttendeeResponse.DECLINED);
        }
        finally {
            executeListener.set(false);
        }
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, user5IdentityId);
        Assert.assertTrue((boolean)eventReminders.isEmpty());
        List<EventReminderParameter> userDefaultRemindersSettings = Collections.singletonList(new EventReminderParameter(2, ReminderPeriodType.DAY));
        AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(user5IdentityId);
        agendaUserSettings.setReminders(userDefaultRemindersSettings);
        this.agendaUserSettingsService.saveAgendaUserSettings(user5IdentityId, agendaUserSettings);
        executeListener.set(true);
        try {
            this.agendaEventAttendeeService.sendEventResponse(eventId, user5IdentityId, EventAttendeeResponse.ACCEPTED);
        }
        finally {
            executeListener.set(false);
        }
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, user5IdentityId);
        Assert.assertEquals((long)userDefaultRemindersSettings.size(), (long)eventReminders.size());
    }
}

