/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.listener.AgendaEventReminderCleanerListener;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventReminderCleanerListenerTest
extends BaseAgendaEventTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanEventReminders() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        org.exoplatform.agenda.model.Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), userIdentityId, this.testuser4Identity, this.testuser5Identity);
        long eventId = event.getId();
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        final AtomicBoolean executeListener = new AtomicBoolean(true);
        this.listenerService.addListener("exo.agenda.event.updated", (Listener)new Listener<AgendaEventModification, Object>(this){

            public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
                if (executeListener.get()) {
                    new AgendaEventReminderCleanerListener().onEvent(event);
                }
            }
        });
        try {
            event.setStatus(EventStatus.CANCELLED);
            this.agendaEventService.updateEvent(event, Collections.emptyList(), Collections.emptyList(), eventReminders, Collections.emptyList(), null, false, userIdentityId);
        }
        finally {
            executeListener.set(false);
        }
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertTrue((boolean)eventReminders.isEmpty());
    }
}

