/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AgendaSpaceApplicationListenerTest {
    protected static final AtomicBoolean LISTENER_INSTALL_COUNT = new AtomicBoolean(false);
    protected static final AtomicBoolean LISTENER_UNINSTALL_COUNT = new AtomicBoolean(false);
    protected static PortalContainer container;
    protected static SpaceService spaceService;

    @BeforeClass
    public static void setUpAllTests() {
        container = PortalContainer.getInstance();
        spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        ListenerService listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class);
        listenerService.addListener("agenda.space.application.installed", (ListenerBase)new Listener<Space, SpaceLifeCycleEvent.Type>(){

            public void onEvent(Event<Space, SpaceLifeCycleEvent.Type> event) throws Exception {
                LISTENER_INSTALL_COUNT.set(true);
            }
        });
        listenerService.addListener("agenda.space.application.uniinstalled", (ListenerBase)new Listener<Space, SpaceLifeCycleEvent.Type>(){

            public void onEvent(Event<Space, SpaceLifeCycleEvent.Type> event) throws Exception {
                LISTENER_UNINSTALL_COUNT.set(true);
            }
        });
    }

    @Before
    public void setUp() {
        LISTENER_INSTALL_COUNT.set(false);
        LISTENER_UNINSTALL_COUNT.set(false);
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity("root", Collections.emptyList())));
        this.begin();
    }

    @After
    public void tearDown() throws Exception {
        ListAccess allSpacesListAccess = spaceService.getAllSpacesWithListAccess();
        int size = allSpacesListAccess.getSize();
        if (size > 0) {
            Space[] spaces;
            for (Space space : spaces = (Space[])allSpacesListAccess.load(0, size)) {
                spaceService.deleteSpace(space);
            }
        }
        ConversationState.setCurrent(null);
        this.end();
    }

    @Test
    public void testCreateSpaceWithAgendaSpaceTemplate() {
        this.createSpace("Space Test with Agenda app Template", "agendaTemplate", "root");
        Assert.assertTrue((boolean)LISTENER_INSTALL_COUNT.get());
        Assert.assertFalse((boolean)LISTENER_UNINSTALL_COUNT.get());
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    protected Space createSpace(String displayName, String spaceTemplate, String ... members) {
        Space newSpace = new Space();
        newSpace.setDisplayName(displayName);
        newSpace.setPrettyName(displayName);
        newSpace.setManagers(new String[]{"root"});
        newSpace.setMembers(members);
        newSpace.setRegistration("open");
        newSpace.setVisibility("private");
        newSpace.setTemplate(spaceTemplate);
        return spaceService.createSpace(newSpace, "root");
    }
}

