/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.EventReminderParameter;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.junit.Assert;
import org.junit.Test;

public class AgendaUserSettingsServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testDefaultSettings() throws Exception {
        AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(56111L);
        Assert.assertNotNull((Object)agendaUserSettings);
        Assert.assertNotNull((Object)agendaUserSettings.getRemoteProviders());
        Assert.assertNotNull((Object)agendaUserSettings.getAgendaDefaultView());
        Assert.assertNotNull((Object)agendaUserSettings.getAgendaWeekStartOn());
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)agendaUserSettings.getConnectedRemoteProvider()));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)agendaUserSettings.getConnectedRemoteUserId()));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)agendaUserSettings.getTimeZoneId()));
        Assert.assertNotNull((Object)agendaUserSettings.getWorkingTimeEnd());
        Assert.assertNotNull((Object)agendaUserSettings.getWorkingTimeStart());
    }

    @Test
    public void testSaveUserSettings() throws Exception {
        long identityId = 2223L;
        AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
        agendaUserSettings.setAgendaDefaultView("agendaDefaultView");
        agendaUserSettings.setAgendaWeekStartOn("agendaWeekStartOn");
        agendaUserSettings.setConnectedRemoteProvider("connectedRemoteProvider");
        agendaUserSettings.setConnectedRemoteUserId("connectedRemoteUserId");
        agendaUserSettings.setReminders(Collections.singletonList(new EventReminderParameter(5, ReminderPeriodType.DAY)));
        agendaUserSettings.setShowWorkingTime(false);
        agendaUserSettings.setWorkingTimeEnd("workingTimeEnd");
        agendaUserSettings.setWorkingTimeStart("workingTimeStart");
        agendaUserSettings.setTimeZoneId("timeZoneId");
        this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
        AgendaUserSettings storedAgendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
        Assert.assertEquals((Object)agendaUserSettings.getAgendaDefaultView(), (Object)storedAgendaUserSettings.getAgendaDefaultView());
        Assert.assertEquals((Object)agendaUserSettings.getAgendaWeekStartOn(), (Object)storedAgendaUserSettings.getAgendaWeekStartOn());
        Assert.assertEquals((Object)agendaUserSettings.getConnectedRemoteProvider(), (Object)storedAgendaUserSettings.getConnectedRemoteProvider());
        Assert.assertEquals((Object)agendaUserSettings.getConnectedRemoteUserId(), (Object)storedAgendaUserSettings.getConnectedRemoteUserId());
        Assert.assertEquals((Object)agendaUserSettings.getReminders(), (Object)storedAgendaUserSettings.getReminders());
        Assert.assertEquals((Object)agendaUserSettings.getTimeZoneId(), (Object)storedAgendaUserSettings.getTimeZoneId());
        Assert.assertEquals((Object)agendaUserSettings.getTimeZoneId(), (Object)storedAgendaUserSettings.getTimeZoneId());
        Assert.assertEquals((Object)agendaUserSettings.getWorkingTimeEnd(), (Object)storedAgendaUserSettings.getWorkingTimeEnd());
        Assert.assertEquals((Object)agendaUserSettings.getWorkingTimeStart(), (Object)storedAgendaUserSettings.getWorkingTimeStart());
    }

    @Test
    public void testSaveUserConnector() throws Exception {
        long identityId = 2223L;
        RemoteProvider remoteProvider = new RemoteProvider(0L, "connectorName", "Client API Key", "Client Secret Key", true, Boolean.valueOf(true));
        remoteProvider = this.agendaRemoteEventService.saveRemoteProvider(remoteProvider);
        Assert.assertNotNull((Object)remoteProvider);
        this.agendaUserSettingsService.saveUserConnector("connectorName", "connectorUserId", identityId);
        AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
        Assert.assertEquals((Object)"connectorName", (Object)agendaUserSettings.getConnectedRemoteProvider());
        Assert.assertEquals((Object)"connectorUserId", (Object)agendaUserSettings.getConnectedRemoteUserId());
        remoteProvider.setEnabled(false);
        this.agendaRemoteEventService.saveRemoteProvider(remoteProvider);
        try {
            this.agendaUserSettingsService.saveUserConnector("connectorName", "connectorUserId", identityId);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

