/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class AgendaEventReminderListener
extends Listener<EventAttendee, EventAttendee> {
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaUserSettingsService agendaUserSettingsService;
    private AgendaEventService agendaEventService;

    public void onEvent(Event<EventAttendee, EventAttendee> event) throws Exception {
        boolean newResponseNoReminders;
        EventAttendee oldAttendee = (EventAttendee)event.getSource();
        EventAttendee newAttendee = (EventAttendee)event.getData();
        boolean oldResponseNoReminders = oldAttendee == null || EventAttendeeResponse.DECLINED.equals((Object)oldAttendee.getResponse()) || EventAttendeeResponse.NEEDS_ACTION.equals((Object)oldAttendee.getResponse());
        boolean bl = newResponseNoReminders = EventAttendeeResponse.DECLINED.equals((Object)newAttendee.getResponse()) || EventAttendeeResponse.NEEDS_ACTION.equals((Object)newAttendee.getResponse());
        if (oldResponseNoReminders != newResponseNoReminders) {
            long eventId = newAttendee.getEventId();
            long identityId = newAttendee.getIdentityId();
            if (newResponseNoReminders) {
                this.getAgendaEventReminderService().removeUserReminders(eventId, identityId);
            } else {
                org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId);
                AgendaUserSettings agendaUserSettings = this.getAgendaUserSettingsService().getAgendaUserSettings(identityId);
                List reminderParameters = agendaUserSettings.getReminders();
                if (reminderParameters != null && !reminderParameters.isEmpty()) {
                    List reminders = reminderParameters.stream().map(reminderParameter -> new EventReminder(identityId, reminderParameter.getBefore(), reminderParameter.getBeforePeriodType())).collect(Collectors.toList());
                    this.getAgendaEventReminderService().saveEventReminders(agendaEvent, reminders, identityId);
                }
            }
        }
    }

    public AgendaUserSettingsService getAgendaUserSettingsService() {
        if (this.agendaUserSettingsService == null) {
            this.agendaUserSettingsService = (AgendaUserSettingsService)ExoContainerContext.getService(AgendaUserSettingsService.class);
        }
        return this.agendaUserSettingsService;
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)ExoContainerContext.getService(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

