/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZonedDateTime;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.listener.AgendaEventReplyListener;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.listener.Event;
import org.junit.Assert;
import org.junit.Test;

public class AgendaReplyEventNotificationListenerTest
extends BaseAgendaEventTest {
    @Test
    public void testSendNotificationWhenReplyToEvent() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        org.exoplatform.agenda.model.Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser4Identity, this.testuser5Identity);
        long eventParticipantId = Long.parseLong(this.testuser4Identity.getId());
        WebNotificationService webNotificationService = (WebNotificationService)this.container.getComponentInstanceOfType(WebNotificationService.class);
        int initialNotificationsSize = webNotificationService.getNumberOnBadge(this.testuser1Identity.getRemoteId());
        EventAttendee oldAttendeeResponse = new EventAttendee(0L, event.getId(), eventParticipantId, EventAttendeeResponse.NEEDS_ACTION);
        EventAttendee newAttendeeResponse = new EventAttendee(0L, event.getId(), eventParticipantId, EventAttendeeResponse.ACCEPTED);
        AgendaEventReplyListener agendaEventReplyListener = new AgendaEventReplyListener((ExoContainer)this.container);
        agendaEventReplyListener.onEvent(new Event(null, (Object)oldAttendeeResponse, (Object)newAttendeeResponse));
        Assert.assertEquals((long)((long)initialNotificationsSize + 1L), (long)webNotificationService.getNumberOnBadge(this.testuser1Identity.getRemoteId()));
    }
}

