/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.listener.AgendaVotesNotificationListener;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.services.listener.Event;
import org.junit.Assert;
import org.junit.Test;

public class AgendaVotesNotificationListenerTest
extends BaseAgendaEventTest {
    @Test
    public void testSendNotificationWhenVoteForDate() throws Exception {
        ZonedDateTime start;
        org.exoplatform.agenda.model.Event event = new org.exoplatform.agenda.model.Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        org.exoplatform.agenda.model.Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        long eventId = createdEvent.getId();
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        WebNotificationService webNotificationService = (WebNotificationService)this.container.getComponentInstanceOfType(WebNotificationService.class);
        int initialNotificationsSize = webNotificationService.getNumberOnBadge(this.testuser1Identity.getRemoteId());
        this.agendaEventDatePollService.saveEventVotes(createdEvent.getId(), Collections.singletonList(((EventDateOption)dateOptions.get(0)).getId()), Long.parseLong(this.testuser2Identity.getId()));
        AgendaVotesNotificationListener agendaVotesListener = new AgendaVotesNotificationListener(this.container);
        agendaVotesListener.onEvent(new Event(null, (Object)eventId, (Object)Long.parseLong(this.testuser2Identity.getId())));
        Assert.assertEquals((long)((long)initialNotificationsSize + 1L), (long)webNotificationService.getNumberOnBadge(this.testuser1Identity.getRemoteId()));
    }
}

