/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service.notification.plugin;

import java.time.ZonedDateTime;
import java.util.List;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.notification.plugin.EventReminderNotificationPlugin;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Test;

public class EventReminderNotificationPluginTest
extends BaseAgendaEventTest {
    public static final ArgumentLiteral<String> EVENT_TITLE = new ArgumentLiteral(String.class, "eventTitle");

    @Test
    public void testMakeNotificationWhenReminderTriggered() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        Space space = this.createSpace("Test space notifications", this.testuser4Identity.getRemoteId());
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity, this.testuser3Identity, spaceIdentity);
        InitParams initParams = new InitParams();
        ValueParam value = new ValueParam();
        value.setName("EventAddedNotificationPlugin");
        value.setValue("#2222");
        initParams.addParam((Object)value);
        value.setName("agenda.notification.plugin.key");
        value.setValue("2222");
        initParams.addParam((Object)value);
        EventReminderNotificationPlugin eventReminderNotificationPlugin = new EventReminderNotificationPlugin(initParams, this.identityManager, this.agendaEventService, this.agendaCalendarService);
        List eventReminders = this.agendaEventReminderService.getEventReminders(createdEvent.getId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertFalse((boolean)eventReminders.isEmpty());
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA_REMINDER, eventReminders.get(0));
        String eventUrl = System.getProperty("gatein.email.domain.url").concat("portal/classic/agenda?eventId=").concat(String.valueOf(createdEvent.getId()));
        NotificationInfo notificationInfo = eventReminderNotificationPlugin.makeNotification(ctx);
        Assert.assertNotNull((Object)notificationInfo);
        Assert.assertEquals((Object)String.valueOf(createdEvent.getId()), (Object)notificationInfo.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)String.valueOf(createdEvent.getCreatorId()), (Object)notificationInfo.getValueOwnerParameter("ownerId"));
        Assert.assertEquals((Object)createdEvent.getSummary(), (Object)notificationInfo.getValueOwnerParameter("eventTitle"));
        Assert.assertEquals((long)1L, (long)notificationInfo.getSendToUserIds().size());
        Assert.assertTrue((boolean)notificationInfo.getValueOwnerParameter("Url").startsWith(eventUrl));
    }
}

