/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgendaEventPermanentLinkPlugin
implements PermanentLinkPlugin {
    public static final String OBJECT_TYPE = "agendaEvent";
    public static final String URL_FORMAT = "/portal/%s/agenda?eventId=%s";
    @Autowired
    private UserACL userAcl;
    @Autowired
    private UserPortalConfigService portalConfigService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((PermanentLinkService)this.container.getComponentInstanceOfType(PermanentLinkService.class)).addPlugin((PermanentLinkPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
        return this.userAcl.hasAccessPermission(OBJECT_TYPE, object.getObjectId(), identity);
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        return String.format(URL_FORMAT, this.portalConfigService.getMetaPortal(), object.getObjectId());
    }
}

