/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZonedDateTime;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventAttendeeGamificationIntegrationListenerTest
extends BaseAgendaEventTest {
    @Test
    public void testAddGamificationPointsAfterReplyingToAnEvent() throws Exception {
        org.exoplatform.agenda.model.Event event = new org.exoplatform.agenda.model.Event();
        event.setCalendarId(this.spaceCalendar.getId());
        event.setStart(ZonedDateTime.now());
        event.setEnd(ZonedDateTime.now());
        final AtomicBoolean executeListener = new AtomicBoolean(true);
        this.listenerService.addListener("exo.agenda.event.responseSent", (ListenerBase)new Listener<Long, Object>(this){

            public void onEvent(Event<Long, Object> event) throws Exception {
                executeListener.set(true);
            }
        });
        long user1IdentityId = Long.parseLong(this.testuser1Identity.getId());
        org.exoplatform.agenda.model.Event createdEvent = this.createEvent(event, user1IdentityId, this.testuser1Identity);
        EventAttendeeResponse userResponse = EventAttendeeResponse.fromValue((String)"ACCEPTED");
        this.agendaEventAttendeeService.sendEventResponse(createdEvent.getId(), user1IdentityId, userResponse);
        Assert.assertTrue((boolean)executeListener.get());
    }
}

