/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventDatePollServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testCreateEventWithSingleDateOption() throws Exception {
        EventDateOption dateOption;
        ZonedDateTime end;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        try {
            ZonedDateTime start = this.getDate();
            end = start.minusSeconds(1L);
            dateOption = new EventDateOption(0L, 0L, start, end, false, false, null);
            this.agendaEventService.createEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption), null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"start date should be before end date");
        }
        catch (AgendaException start) {
            // empty catch block
        }
        end = start = this.getDate();
        dateOption = new EventDateOption(0L, 0L, start, end, false, false, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption), null, true, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)start.withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getStart());
        Assert.assertEquals((Object)end.withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.CONFIRMED, (Object)createdEvent.getStatus());
        Assert.assertNotNull(eventCreationReference.get());
        Assert.assertEquals((long)createdEvent.getId(), (long)((AgendaEventModification)eventCreationReference.get()).getEventId());
        Assert.assertNull(eventPollCreationReference.get());
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(createdEvent.getId(), (ZoneId)ZoneOffset.UTC);
        Assert.assertTrue((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateEventWithMultipleDateOptions() throws Exception {
        EventDateOption dateOption2;
        EventDateOption dateOption1;
        ZonedDateTime end;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        long creatorIdentityId = Long.parseLong(this.testuser1Identity.getId());
        try {
            ZonedDateTime start = this.getDate();
            end = start.minusSeconds(1L);
            dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
            dateOption2 = new EventDateOption(0L, 0L, start, end, true, false, null);
            this.agendaEventService.createEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, creatorIdentityId);
            Assert.fail((String)"start date should be before end date");
        }
        catch (AgendaException start) {
            // empty catch block
        }
        end = start = this.getDate();
        dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, creatorIdentityId, EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, creatorIdentityId);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)createdEvent.getStatus());
        Assert.assertNotNull(eventPollCreationReference.get());
        Assert.assertEquals((long)createdEvent.getId(), (long)((AgendaEventModification)eventPollCreationReference.get()).getEventId());
        Assert.assertNull(eventCreationReference.get());
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).getEventAttendees();
        Assert.assertNotNull((Object)eventAttendees);
        Assert.assertEquals((long)1L, (long)eventAttendees.size());
        Assert.assertEquals((long)creatorIdentityId, (long)((EventAttendee)eventAttendees.get(0)).getIdentityId());
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)((EventAttendee)eventAttendees.get(0)).getResponse());
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(createdEvent.getId(), (ZoneId)ZoneOffset.UTC);
        Assert.assertFalse((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        EventDateOption createdDateOption1 = (EventDateOption)dateOptions.get(0);
        EventDateOption createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)createdDateOption1.getStart());
        Assert.assertEquals((Object)dateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)createdDateOption1.getEnd());
        Assert.assertEquals((Object)dateOption2.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)createdDateOption2.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)createdDateOption2.getEnd());
    }

    @Test
    public void testUpdateEventWithSingleDateOption() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption = new EventDateOption(0L, 0L, start, end, false, false, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption), null, true, Long.parseLong(this.testuser1Identity.getId()));
        AgendaEventModification eventModifications = (AgendaEventModification)eventCreationReference.get();
        Assert.assertNotNull((Object)eventModifications);
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.ADDED));
        Assert.assertEquals((String)("Modification types are more than expected : " + String.valueOf(eventModifications.getModificationTypes())), (long)1L, (long)eventModifications.getModificationTypes().size());
        try {
            start = this.getDate();
            end = start.minusSeconds(1L);
            dateOption = new EventDateOption(0L, 0L, start, end, false, false, null);
            this.agendaEventService.updateEvent(createdEvent, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption), null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"start date should be before end date");
        }
        catch (AgendaException agendaException) {
            // empty catch block
        }
        end = start = this.getDate().plusDays(1L);
        dateOption = new EventDateOption(0L, 0L, start, end, true, false, null);
        Event updatedEvent = this.agendaEventService.updateEvent(createdEvent, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption), null, true, Long.parseLong(this.testuser1Identity.getId()));
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(createdEvent.getId(), (ZoneId)ZoneOffset.UTC);
        Assert.assertTrue((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)EventStatus.CONFIRMED, (Object)event.getStatus());
        eventModifications = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModifications);
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.START_DATE_UPDATED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.END_DATE_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + String.valueOf(eventModifications.getModificationTypes())), (long)3L, (long)eventModifications.getModificationTypes().size());
        Assert.assertTrue((boolean)updatedEvent.isAllDay());
        Assert.assertEquals((Object)dateOption.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)updatedEvent.getStart());
        Assert.assertEquals((Object)dateOption.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)updatedEvent.getEnd());
    }

    @Test
    public void testUpdateEventWithMultipleDateOptions() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.NEEDS_ACTION), new EventAttendee(0L, Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.NEEDS_ACTION), new EventAttendee(0L, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        try {
            ZonedDateTime startTmp = this.getDate();
            ZonedDateTime endTmp = start.minusSeconds(1L);
            EventDateOption dateOptionTmp1 = new EventDateOption(0L, 0L, startTmp, endTmp, false, false, null);
            EventDateOption dateOptionTmp2 = new EventDateOption(0L, 0L, startTmp, endTmp, true, false, null);
            this.agendaEventService.createEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOptionTmp1, dateOptionTmp2), null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"start date should be before end date");
        }
        catch (AgendaException startTmp) {
            // empty catch block
        }
        long eventId = createdEvent.getId();
        dateOption1.setAllDay(true);
        dateOption1.setStart(dateOption1.getStart().plusDays(1L));
        dateOption1.setEnd(dateOption1.getEnd().plusDays(1L));
        List eventDateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, null);
        this.agendaEventDatePollService.saveEventVotes(eventId, eventDateOptions.stream().map(EventDateOption::getId).collect(Collectors.toList()), Long.parseLong(this.testuser3Identity.getId()));
        EventAttendeeResponse eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((Object)EventAttendeeResponse.TENTATIVE, (Object)eventResponse);
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Event updatedEvent = this.agendaEventService.updateEvent(createdEvent, eventAttendees, Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)updatedEvent);
        Assert.assertEquals((Object)dateOption2.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)updatedEvent.getStart());
        Assert.assertEquals((Object)dateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)updatedEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)updatedEvent.getStatus());
        eventResponse = this.agendaEventAttendeeService.getEventResponse(eventId, null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((Object)EventAttendeeResponse.NEEDS_ACTION, (Object)eventResponse);
        AgendaEventModification eventModifications = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModifications);
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.DATE_OPTION_CREATED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.DATE_OPTION_DELETED));
        Assert.assertEquals((String)("Modification types are more than expected : " + String.valueOf(eventModifications.getModificationTypes())), (long)3L, (long)eventModifications.getModificationTypes().size());
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(updatedEvent.getId(), (ZoneId)ZoneOffset.UTC);
        Assert.assertFalse((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        EventDateOption createdDateOption1 = (EventDateOption)dateOptions.get(1);
        EventDateOption createdDateOption2 = (EventDateOption)dateOptions.get(0);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)createdDateOption1.getStart());
        Assert.assertEquals((Object)dateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)createdDateOption1.getEnd());
        Assert.assertEquals((Object)dateOption2.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)createdDateOption2.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)createdDateOption2.getEnd());
        Assert.assertEquals((Object)dateOption2.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)createdDateOption2.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)createdDateOption2.getEnd());
        updatedEvent = this.agendaEventService.updateEvent(updatedEvent, eventAttendees, Collections.emptyList(), Collections.emptyList(), Arrays.asList(createdDateOption1, createdDateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModifications = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModifications);
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + String.valueOf(eventModifications.getModificationTypes())), (long)1L, (long)eventModifications.getModificationTypes().size());
        createdDateOption1.setStart(createdDateOption1.getStart().plusDays(1L));
        createdDateOption1.setEnd(createdDateOption1.getEnd().plusDays(1L));
        this.agendaEventService.updateEvent(updatedEvent, eventAttendees, Collections.emptyList(), Collections.emptyList(), Arrays.asList(createdDateOption1, createdDateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModifications = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModifications);
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.DATE_OPTION_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + String.valueOf(eventModifications.getModificationTypes())), (long)2L, (long)eventModifications.getModificationTypes().size());
    }

    @Test
    public void testUpdateEventFromMultipleToSingleDateOption() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)createdEvent.getStatus());
        dateOption1.setAllDay(true);
        dateOption1.setStart(dateOption1.getStart().plusDays(1L));
        dateOption1.setEnd(dateOption1.getEnd().plusDays(1L));
        Event updatedEvent = this.agendaEventService.updateEvent(createdEvent, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1), null, true, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)updatedEvent);
        Assert.assertTrue((boolean)updatedEvent.isAllDay());
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)updatedEvent.getStart());
        Assert.assertEquals((Object)dateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)updatedEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.CONFIRMED, (Object)updatedEvent.getStatus());
    }

    @Test
    public void testUpdateEventFromSingleToMultipleDateOption() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1), null, true, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)EventStatus.CONFIRMED, (Object)createdEvent.getStatus());
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(createdEvent.getId(), (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)0L, (long)dateOptions.size());
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event updatedEvent = this.agendaEventService.updateEvent(createdEvent, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)updatedEvent);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)updatedEvent.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)updatedEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)updatedEvent.getStatus());
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(updatedEvent.getId(), (ZoneId)ZoneOffset.UTC);
        Assert.assertFalse((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        this.agendaEventService.updateEvent(updatedEvent, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), dateOptions, null, true, Long.parseLong(this.testuser1Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(updatedEvent.getId(), (ZoneId)ZoneOffset.UTC);
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        EventDateOption createdDateOption1 = (EventDateOption)dateOptions.get(0);
        EventDateOption createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)createdDateOption1.getStart());
        Assert.assertEquals((Object)dateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)createdDateOption1.getEnd());
        Assert.assertEquals((Object)dateOption2.getStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC), (Object)createdDateOption2.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L), (Object)createdDateOption2.getEnd());
    }

    @Test
    public void testSelectEventDateOption() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.NEEDS_ACTION), new EventAttendee(0L, Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        long eventId = createdEvent.getId();
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertFalse((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        EventDateOption createdDateOption1 = (EventDateOption)dateOptions.get(0);
        EventDateOption createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertFalse((boolean)createdDateOption1.isSelected());
        Assert.assertFalse((boolean)createdDateOption2.isSelected());
        try {
            this.agendaEventService.selectEventDateOption(0L, createdDateOption1.getId(), Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventService.selectEventDateOption(eventId, createdDateOption1.getId(), Long.parseLong(this.testuser3Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventService.selectEventDateOption(eventId, 3000L, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        this.agendaEventService.selectEventDateOption(eventId, createdDateOption1.getId(), Long.parseLong(this.testuser1Identity.getId()));
        AgendaEventModification eventModifications = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModifications);
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.DATE_OPTION_SELECTED));
        Assert.assertTrue((boolean)eventModifications.hasModification(AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT));
        Assert.assertEquals((String)("Modification types are more than expected : " + String.valueOf(eventModifications.getModificationTypes())), (long)3L, (long)eventModifications.getModificationTypes().size());
        Event updatedEvent = this.agendaEventService.getEventById(eventId);
        Assert.assertNotNull((Object)updatedEvent);
        Assert.assertEquals((Object)createdDateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)updatedEvent.getStart());
        Assert.assertEquals((Object)createdDateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)updatedEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.CONFIRMED, (Object)updatedEvent.getStatus());
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertFalse((dateOptions == null || dateOptions.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        createdDateOption1 = (EventDateOption)dateOptions.get(0);
        createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertTrue((boolean)createdDateOption1.isSelected());
        Assert.assertFalse((boolean)createdDateOption2.isSelected());
    }

    @Test
    public void testVoteEventDateOption() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser1Identity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        long eventId = createdEvent.getId();
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        EventDateOption createdDateOption1 = (EventDateOption)dateOptions.get(0);
        EventDateOption createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((String)"Creator should have accepted automatically proposed date options", (Object)createdDateOption1.getVoters());
        Assert.assertEquals((String)"Creator should have accepted automatically proposed date options", (long)1L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((String)"Creator should have accepted automatically proposed date options", (Object)createdDateOption2.getVoters());
        Assert.assertEquals((String)"Creator should have accepted automatically proposed date options", (long)1L, (long)createdDateOption2.getVoters().size());
        try {
            this.agendaEventDatePollService.voteDateOption(5000L, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"Date Option shouldn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventDatePollService.voteDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)"User is not attendee, thus shouldn't be able to vote on it");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventDatePollService.voteDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)"User is not attendee, thus shouldn't be able to vote on it");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.agendaEventService.updateEvent(createdEvent, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), dateOptions, null, true, Long.parseLong(this.testuser1Identity.getId()));
        this.agendaEventDatePollService.voteDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
        this.agendaEventDatePollService.voteDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        createdDateOption1 = (EventDateOption)dateOptions.get(0);
        createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((Object)createdDateOption1.getVoters());
        Assert.assertEquals((long)2L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((Object)createdDateOption2.getVoters());
        Assert.assertEquals((long)1L, (long)createdDateOption2.getVoters().size());
        this.agendaEventDatePollService.voteDateOption(createdDateOption2.getId(), Long.parseLong(this.testuser2Identity.getId()));
        this.agendaEventDatePollService.voteDateOption(createdDateOption2.getId(), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        createdDateOption1 = (EventDateOption)dateOptions.get(0);
        createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((Object)createdDateOption1.getVoters());
        Assert.assertEquals((long)2L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((Object)createdDateOption2.getVoters());
        Assert.assertEquals((long)2L, (long)createdDateOption2.getVoters().size());
    }

    @Test
    public void testDismissEventDateOption() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        long eventId = createdEvent.getId();
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        EventDateOption createdDateOption1 = (EventDateOption)dateOptions.get(0);
        EventDateOption createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((String)"Creator should have accepted automatically proposed date options", (Object)createdDateOption1.getVoters());
        Assert.assertEquals((String)"Creator should have accepted automatically proposed date options", (long)1L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((String)"Creator should have accepted automatically proposed date options", (Object)createdDateOption2.getVoters());
        Assert.assertEquals((String)"Creator should have accepted automatically proposed date options", (long)1L, (long)createdDateOption2.getVoters().size());
        try {
            this.agendaEventDatePollService.dismissDateOption(5000L, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"Date Option shouldn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventDatePollService.dismissDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
        }
        catch (Exception e) {
            Assert.fail((String)"User should be able to dismiss his vote even if he's not an attendee anymore");
        }
        this.agendaEventService.updateEvent(createdEvent, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), dateOptions, null, true, Long.parseLong(this.testuser1Identity.getId()));
        this.agendaEventDatePollService.voteDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        createdDateOption1 = (EventDateOption)dateOptions.get(0);
        createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((Object)createdDateOption1.getVoters());
        Assert.assertEquals((long)2L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((Object)createdDateOption2.getVoters());
        Assert.assertEquals((long)1L, (long)createdDateOption2.getVoters().size());
        this.agendaEventDatePollService.dismissDateOption(createdDateOption1.getId(), Long.parseLong(this.testuser2Identity.getId()));
        this.agendaEventDatePollService.voteDateOption(createdDateOption2.getId(), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        createdDateOption1 = (EventDateOption)dateOptions.get(0);
        createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((Object)createdDateOption1.getVoters());
        Assert.assertEquals((long)1L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((Object)createdDateOption2.getVoters());
        Assert.assertEquals((long)2L, (long)createdDateOption2.getVoters().size());
        this.agendaEventDatePollService.dismissDateOption(createdDateOption2.getId(), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        createdDateOption1 = (EventDateOption)dateOptions.get(0);
        createdDateOption2 = (EventDateOption)dateOptions.get(1);
        Assert.assertNotNull((Object)createdDateOption1.getVoters());
        Assert.assertEquals((long)1L, (long)createdDateOption1.getVoters().size());
        Assert.assertNotNull((Object)createdDateOption2.getVoters());
        Assert.assertEquals((long)1L, (long)createdDateOption2.getVoters().size());
    }

    @Test
    public void testSaveEventVotes() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.NEEDS_ACTION)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, Long.parseLong(this.testuser1Identity.getId()));
        long eventId = createdEvent.getId();
        List dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertNotNull((Object)dateOptions);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        try {
            this.agendaEventDatePollService.saveEventVotes(2000L, Collections.emptyList(), Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail((String)"Event with id shouldn't exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.agendaEventDatePollService.saveEventVotes(eventId, Collections.emptyList(), Long.parseLong(this.testuser5Identity.getId()));
            Assert.fail((String)"User is not attendee, thus shouldn't be able to vote on it");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.agendaEventDatePollService.saveEventVotes(eventId, Collections.singletonList(((EventDateOption)dateOptions.get(0)).getId()), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertNotNull((Object)dateOptions);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        Assert.assertNotNull((Object)((EventDateOption)dateOptions.get(0)).getVoters());
        Assert.assertEquals((long)2L, (long)((EventDateOption)dateOptions.get(0)).getVoters().size());
        Assert.assertNotNull((Object)((EventDateOption)dateOptions.get(1)).getVoters());
        Assert.assertEquals((long)1L, (long)((EventDateOption)dateOptions.get(1)).getVoters().size());
        this.agendaEventDatePollService.saveEventVotes(eventId, Collections.singletonList(((EventDateOption)dateOptions.get(1)).getId()), Long.parseLong(this.testuser2Identity.getId()));
        dateOptions = this.agendaEventDatePollService.getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
        Assert.assertNotNull((Object)dateOptions);
        Assert.assertEquals((long)2L, (long)dateOptions.size());
        dateOptions.sort((option1, option2) -> option1.getStart().compareTo(option2.getStart()));
        Assert.assertNotNull((Object)((EventDateOption)dateOptions.get(0)).getVoters());
        Assert.assertEquals((long)1L, (long)((EventDateOption)dateOptions.get(0)).getVoters().size());
        Assert.assertNotNull((Object)((EventDateOption)dateOptions.get(1)).getVoters());
        Assert.assertEquals((long)2L, (long)((EventDateOption)dateOptions.get(1)).getVoters().size());
    }

    @Test
    public void testGetPendingDatePolls() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        long creatorIdentityId = Long.parseLong(this.testuser1Identity.getId());
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser4Identity.getId()), EventAttendeeResponse.ACCEPTED), new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, creatorIdentityId);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)createdEvent.getStatus());
        EventFilter eventFilter = new EventFilter();
        eventFilter.setAttendeeId(creatorIdentityId);
        eventFilter.setLimit(10);
        List eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, creatorIdentityId);
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        eventFilter.setAttendeeId(Long.parseLong(this.testuser2Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        eventFilter.setAttendeeId(Long.parseLong(this.testuser4Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        eventFilter.setAttendeeId(Long.parseLong(this.testuser5Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)0L, (long)eventDatePolls.size());
        eventFilter.setOwnerIds(Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())));
        eventFilter.setAttendeeId(Long.parseLong(this.testuser1Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        List eventDatePolls1 = new ArrayList();
        try {
            eventDatePolls1 = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Assert.assertNotNull(eventDatePolls1);
        Assert.assertEquals((long)0L, (long)eventDatePolls1.size());
    }

    @Test
    public void testGetDatePollsByDates() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        event.setRecurrence(null);
        long creatorIdentityId = Long.parseLong(this.testuser1Identity.getId());
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, start.plusDays(1L), end.plusDays(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser4Identity.getId()), EventAttendeeResponse.ACCEPTED), new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2), null, true, creatorIdentityId);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getStart());
        Assert.assertEquals((Object)dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getEnd());
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)createdEvent.getStatus());
        EventFilter eventFilter = new EventFilter();
        eventFilter.setAttendeeId(creatorIdentityId);
        eventFilter.setStart(start);
        eventFilter.setEnd(start.plusMinutes(1L));
        List eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, creatorIdentityId);
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        eventFilter.setAttendeeId(Long.parseLong(this.testuser2Identity.getId()));
        eventFilter.setStart(end.plusDays(1L).minusMinutes(1L));
        eventFilter.setEnd(end.plusDays(2L));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        eventFilter.setAttendeeId(Long.parseLong(this.testuser4Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        eventFilter.setAttendeeId(Long.parseLong(this.testuser5Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)0L, (long)eventDatePolls.size());
        eventFilter.setOwnerIds(Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())));
        eventFilter.setAttendeeId(Long.parseLong(this.testuser1Identity.getId()));
        eventDatePolls = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventDatePolls);
        Assert.assertEquals((long)1L, (long)eventDatePolls.size());
        List eventDatePolls1 = new ArrayList();
        try {
            eventDatePolls1 = this.agendaEventService.getEventDatePolls(eventFilter, (ZoneId)ZoneOffset.UTC, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Assert.assertNotNull(eventDatePolls1);
        Assert.assertEquals((long)0L, (long)eventDatePolls1.size());
    }

    @Test
    public void testCountPendingDatePolls() throws Exception {
        ZonedDateTime start;
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        EventRecurrence recurrence = new EventRecurrence();
        event.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
        recurrence.setInterval(1);
        long creatorIdentityId = Long.parseLong(this.testuser1Identity.getId());
        ZonedDateTime end = start = this.getDate();
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, start, end, false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, ZonedDateTime.now(), ZonedDateTime.now().plusHours(1L), true, true, null);
        EventDateOption dateOption3 = new EventDateOption(0L, 0L, ZonedDateTime.now().plusDays(1L), ZonedDateTime.now().plusDays(1L).plusHours(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser4Identity.getId()), EventAttendeeResponse.ACCEPTED), new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2, dateOption3), null, true, creatorIdentityId);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC).withNano(0), (Object)createdEvent.getStart().withNano(0));
        Assert.assertEquals((Object)dateOption3.getEnd().withZoneSameInstant(ZoneOffset.UTC).withNano(0), (Object)createdEvent.getEnd().withNano(0));
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)createdEvent.getStatus());
        long eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertEquals((long)1L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)1L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)1L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)0L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertEquals((long)1L, (long)eventDatePollCount);
        long eventDatePollCount1 = 0L;
        try {
            eventDatePollCount1 = this.agendaEventService.countEventDatePolls(Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)eventDatePollCount1);
    }

    @Test
    public void testCountPastPendingDatePolls() throws Exception {
        Event event = new Event();
        event.setCalendarId(this.spaceCalendar.getId());
        event.setRecurrence(null);
        long creatorIdentityId = Long.parseLong(this.testuser1Identity.getId());
        EventDateOption dateOption1 = new EventDateOption(0L, 0L, ZonedDateTime.now().minusDays(2L), ZonedDateTime.now().minusDays(1L), false, false, null);
        EventDateOption dateOption2 = new EventDateOption(0L, 0L, ZonedDateTime.now().minusHours(2L), ZonedDateTime.now().minusHours(1L), true, true, null);
        EventDateOption dateOption3 = new EventDateOption(0L, 0L, ZonedDateTime.now().minusMinutes(2L), ZonedDateTime.now().minusMinutes(1L), true, true, null);
        Event createdEvent = this.agendaEventService.createEvent(event, Arrays.asList(new EventAttendee(0L, Long.parseLong(this.testuser4Identity.getId()), EventAttendeeResponse.ACCEPTED), new EventAttendee(0L, Long.parseLong(this.spaceIdentity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), Arrays.asList(dateOption1, dateOption2, dateOption3), null, true, creatorIdentityId);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertEquals((Object)dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC).withNano(0), (Object)createdEvent.getStart().withNano(0));
        Assert.assertEquals((Object)dateOption3.getEnd().withZoneSameInstant(ZoneOffset.UTC).withNano(0), (Object)createdEvent.getEnd().withNano(0));
        Assert.assertEquals((Object)EventStatus.TENTATIVE, (Object)createdEvent.getStatus());
        long eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertEquals((long)0L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)0L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)0L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.emptyList(), Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)0L, (long)eventDatePollCount);
        eventDatePollCount = this.agendaEventService.countEventDatePolls(Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertEquals((long)0L, (long)eventDatePollCount);
    }
}

