/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.dao;

import java.io.Serializable;
import junit.framework.TestCase;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.naming.InitialContextInitializer;

public class CalendarDAOTest
extends TestCase {
    private PortalContainer container;
    private CalendarDAO calendarDAO;

    protected void setUp() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        this.container = PortalContainer.getInstance();
        this.calendarDAO = (CalendarDAO)this.container.getComponentInstanceOfType(CalendarDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    private void end() {
        RequestLifeCycle.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateCalendar() {
        CalendarEntity calendarEntity = new CalendarEntity();
        String color = "Color";
        String description = "Description";
        long ownerId = 2L;
        boolean isSystem = true;
        calendarEntity.setColor(color);
        calendarEntity.setDescription(description);
        calendarEntity.setOwnerId(Long.valueOf(ownerId));
        calendarEntity.setSystem(isSystem);
        try {
            calendarEntity = this.calendarDAO.create(calendarEntity);
            CalendarDAOTest.assertNotNull((Object)calendarEntity.getId());
            CalendarDAOTest.assertEquals((String)color, (String)calendarEntity.getColor());
            CalendarDAOTest.assertEquals((String)description, (String)calendarEntity.getDescription());
            CalendarDAOTest.assertNotNull((Object)calendarEntity.getOwnerId());
            CalendarDAOTest.assertEquals((long)ownerId, (long)calendarEntity.getOwnerId());
            CalendarDAOTest.assertEquals((boolean)isSystem, (boolean)calendarEntity.isSystem());
        }
        finally {
            this.calendarDAO.delete(calendarEntity);
        }
    }

    public void testDeleteCalendar() {
        CalendarEntity calendarEntity = new CalendarEntity();
        String color = "Color";
        String description = "Description";
        long ownerId = 2L;
        boolean isSystem = true;
        calendarEntity.setColor(color);
        calendarEntity.setDescription(description);
        calendarEntity.setOwnerId(Long.valueOf(ownerId));
        calendarEntity.setSystem(isSystem);
        calendarEntity = this.calendarDAO.create(calendarEntity);
        CalendarDAOTest.assertNotNull((Object)calendarEntity.getId());
        this.calendarDAO.delete(calendarEntity);
        calendarEntity = (CalendarEntity)this.calendarDAO.find((Serializable)calendarEntity.getId());
        CalendarDAOTest.assertNull((Object)calendarEntity);
    }

    private void begin() {
        RequestLifeCycle.begin((ExoContainer)this.container);
    }
}

