/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.dao.EventConferenceDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.entity.EventConferenceEntity;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.services.listener.ListenerService;

public class AgendaEventConferenceStorage {
    private EventDAO eventDAO;
    private EventConferenceDAO eventConferenceDAO;
    private ListenerService listenerService;

    public AgendaEventConferenceStorage(EventDAO eventDAO, EventConferenceDAO eventConferenceDAO, ListenerService listenerService) {
        this.eventDAO = eventDAO;
        this.eventConferenceDAO = eventConferenceDAO;
        this.listenerService = listenerService;
    }

    public List<EventConference> getEventConferences(long eventId) {
        List<EventConferenceEntity> eventConferenceEntities = this.eventConferenceDAO.getEventConferences(eventId);
        if (eventConferenceEntities == null) {
            return Collections.emptyList();
        }
        return eventConferenceEntities.stream().map(EntityMapper::fromEntity).collect(Collectors.toList());
    }

    public EventConference saveEventConference(EventConference eventConference) {
        long eventId = eventConference.getEventId();
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            throw new IllegalStateException("Can't find event with id " + eventId);
        }
        EventConferenceEntity eventConferenceEntity = EntityMapper.toEntity(eventConference);
        eventConferenceEntity.setEvent(eventEntity);
        if (eventConference.getId() <= 0L) {
            eventConferenceEntity.setId(null);
            eventConferenceEntity = (EventConferenceEntity)this.eventConferenceDAO.create(eventConferenceEntity);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.conference.created", eventId, eventConferenceEntity.getId());
        } else {
            eventConferenceEntity = (EventConferenceEntity)this.eventConferenceDAO.update(eventConferenceEntity);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.conference.updated", eventId, eventConferenceEntity.getId());
        }
        return EntityMapper.fromEntity(eventConferenceEntity);
    }

    public void removeEventConference(long conferenceId) {
        EventConferenceEntity eventConferenceEntity = (EventConferenceEntity)this.eventConferenceDAO.find(Long.valueOf(conferenceId));
        if (eventConferenceEntity != null) {
            this.eventConferenceDAO.delete(eventConferenceEntity);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.conference.deleted", eventConferenceEntity.getEvent().getId(), eventConferenceEntity.getId());
        }
    }
}

