/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.service.AgendaCalendarServiceImpl;
import org.exoplatform.agenda.storage.AgendaCalendarStorage;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class AgendaCalendarServiceTest {
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private AgendaCalendarStorage agendaCalendarStorage;
    private AgendaCalendarServiceImpl agendaCalendarService;

    @Before
    public void setUp() {
        this.spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.agendaCalendarStorage = (AgendaCalendarStorage)Mockito.mock(AgendaCalendarStorage.class);
        InitParams initParams = new InitParams();
        ValuesParam value = new ValuesParam();
        value.setName("defaultColors");
        value.setValues(Collections.singletonList("#111111"));
        initParams.addParam((Object)value);
        this.agendaCalendarService = new AgendaCalendarServiceImpl(this.agendaCalendarStorage, this.identityManager, this.spaceService, initParams);
    }

    @Test
    public void testGetCalendarById() {
        long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "testuser";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Profile calendarOwnerProfile = new Profile();
        calendarOwnerProfile.setProperty("fullName", (Object)username);
        calendarOwnerIdentity.setProfile(calendarOwnerProfile);
        Calendar calendar = new Calendar(calendarId, calendarOwnerId, true, "title", "description", AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()), AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()), "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)username))).thenReturn((Object)calendarOwnerIdentity);
        try {
            this.agendaCalendarService.getCalendarById(0L);
            Assert.fail((String)"Should throw an exception when username is null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Calendar retrievedCalendar = this.agendaCalendarService.getCalendarById(calendarId);
        Assert.assertNotNull((Object)retrievedCalendar);
        Assert.assertEquals((Object)calendar, (Object)retrievedCalendar);
        Assert.assertEquals((Object)username, (Object)calendar.getTitle());
        long notExistingCalendarId = calendarId + 2L;
        retrievedCalendar = this.agendaCalendarService.getCalendarById(notExistingCalendarId);
        Assert.assertNull((String)"Should return null when trying to retrieve inexistant calendar", (Object)retrievedCalendar);
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn(null);
        retrievedCalendar = this.agendaCalendarService.getCalendarById(calendarId);
        Assert.assertNotNull((Object)retrievedCalendar);
        Assert.assertTrue((boolean)retrievedCalendar.isDeleted());
    }

    @Test
    public void testGetOrCreateCalendarByOwnerId() throws Exception {
        long calendarOwnerId = 2L;
        String username = "testuser";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.agendaCalendarStorage.countCalendarsByOwners((Long[])Mockito.any())).thenReturn((Object)0);
        this.agendaCalendarService.getOrCreateCalendarByOwnerId(calendarOwnerId);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)1))).createCalendar((Calendar)Mockito.any());
    }

    @Test
    public void testGetOrCreateCalendarByOwnerId_NoCreate() throws Exception {
        long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "testuser";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.agendaCalendarStorage.countCalendarsByOwners((Long[])Mockito.any())).thenReturn((Object)1);
        Calendar calendar = new Calendar(calendarId, calendarOwnerId, true, "title", "description", AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()), AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()), "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarIdsByOwnerIds(Mockito.anyInt(), Mockito.anyInt(), (Long[])Mockito.any())).thenReturn(Collections.singletonList(calendar.getId()));
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        Calendar retrievedCalendar = this.agendaCalendarService.getOrCreateCalendarByOwnerId(calendarOwnerId);
        Assert.assertEquals((Object)calendar, (Object)retrievedCalendar);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)0))).createCalendar((Calendar)Mockito.any());
    }

    @Test
    public void testGetCalendarByIdAndUsername() throws Exception {
        long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "testuser";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Profile calendarOwnerProfile = new Profile();
        calendarOwnerProfile.setProperty("fullName", (Object)username);
        calendarOwnerIdentity.setProfile(calendarOwnerProfile);
        Calendar calendar = new Calendar(calendarId, calendarOwnerId, true, "title", "description", AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()), AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()), "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)username))).thenReturn((Object)calendarOwnerIdentity);
        try {
            this.agendaCalendarService.getCalendarById(0L, username);
            Assert.fail((String)"Should throw an exception when calendar id is not positive");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.getCalendarById(calendarId, null);
            Assert.fail((String)"Should throw an exception when username is null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Calendar retrievedCalendar = this.agendaCalendarService.getCalendarById(calendarId, username);
        Assert.assertNotNull((String)"User should be able to access his own calendar", (Object)retrievedCalendar);
        Assert.assertNotNull((String)"ACL of calendar should have been computed", (Object)retrievedCalendar.getAcl());
        Assert.assertTrue((String)"User should be able to modify calendar", (boolean)retrievedCalendar.getAcl().isCanEdit());
        retrievedCalendar.setAcl(null);
        Assert.assertEquals((String)"Retrieved calendar should be the same as the retrieved from storage", (Object)calendar, (Object)retrievedCalendar);
        long notExistingCalendarId = calendarId + 2L;
        retrievedCalendar = this.agendaCalendarService.getCalendarById(notExistingCalendarId, username);
        Assert.assertNull((String)"Should return null when trying to retrieve inexistant calendar", (Object)retrievedCalendar);
        try {
            this.agendaCalendarService.getCalendarById(calendarId, "inexistantuser");
            Assert.fail((String)"should throw an error when trying to retrieve calendar with not found user");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String spacePrettyName = "spacetest";
        calendarOwnerIdentity = new Identity("space", spacePrettyName);
        calendarOwnerIdentity.setId(String.valueOf(++calendarOwnerId));
        calendar.setOwnerId(calendarOwnerId);
        Mockito.when((Object)this.identityManager.getIdentity(calendarOwnerIdentity.getId())).thenReturn((Object)calendarOwnerIdentity);
        Space space = new Space();
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)false);
        try {
            this.agendaCalendarService.getCalendarById(calendarId, username);
            Assert.fail((String)"User shouldn't acces calendar of a space where he don't belong");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        retrievedCalendar = this.agendaCalendarService.getCalendarById(calendarId, username);
        Assert.assertNotNull((String)"User should be able to access his own calendar", (Object)retrievedCalendar);
        Assert.assertNotNull((String)"ACL of calendar should have been computed", (Object)retrievedCalendar.getAcl());
        Assert.assertFalse((String)"User shouldn't be able to modify calendar", (boolean)retrievedCalendar.getAcl().isCanEdit());
        retrievedCalendar.setAcl(null);
        Assert.assertEquals((String)"Retrieved calendar should be the same as the retrieved from storage", (Object)calendar, (Object)retrievedCalendar);
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.canManageSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        retrievedCalendar = this.agendaCalendarService.getCalendarById(calendarId, username);
        Assert.assertNotNull((String)"User should be able to access his own calendar", (Object)retrievedCalendar);
        Assert.assertNotNull((String)"ACL of calendar should have been computed", (Object)retrievedCalendar.getAcl());
        Assert.assertTrue((String)"User should be able to modify calendar", (boolean)retrievedCalendar.getAcl().isCanEdit());
        retrievedCalendar.setAcl(null);
        Assert.assertEquals((String)"Retrieved calendar should be the same as the retrieved from storage", (Object)calendar, (Object)retrievedCalendar);
    }

    @Test
    public void testCreateCalendar() {
        final long calendarId = 1L;
        long calendarOwnerId = 2L;
        Identity calendarOwnerIdentity = new Identity("organization", "test");
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Calendar calendar = new Calendar(0L, calendarOwnerId, true, "title", "description", null, null, "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.createCalendar((Calendar)Mockito.eq((Object)calendar))).thenAnswer((Answer)new Answer<Calendar>(){

            public Calendar answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Calendar calendar = (Calendar)args[0];
                calendar.setId(calendarId);
                calendar.setCreated(AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()));
                calendar.setUpdated(null);
                return calendar;
            }
        });
        try {
            this.agendaCalendarService.createCalendar(null);
            Assert.fail((String)"Shouldn't allow to create null calendar");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            calendar.setId(1L);
            this.agendaCalendarService.createCalendar(calendar);
            Assert.fail((String)"Shouldn't allow to create calendar with a not zero id");
        }
        catch (IllegalArgumentException e) {
            calendar.setId(0L);
        }
        try {
            calendar.setOwnerId(-1L);
            this.agendaCalendarService.createCalendar(calendar);
            Assert.fail((String)"Shouldn't allow to create calendar with a negative owner id");
        }
        catch (IllegalArgumentException e) {
            calendar.setOwnerId(calendarOwnerId);
        }
        try {
            this.agendaCalendarService.createCalendar(calendar);
            Assert.fail((String)"Shouldn't allow to create calendar with a not valid calendar owner");
        }
        catch (IllegalStateException e) {
            calendar.setOwnerId(calendarOwnerId);
        }
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        try {
            calendarOwnerIdentity.setProviderId("NotManagerProviderByCalendarAPI");
            this.agendaCalendarService.createCalendar(calendar);
            Assert.fail((String)"Shouldn't allow to create calendar with not managed providerId for calendar owner");
        }
        catch (IllegalStateException e) {
            calendarOwnerIdentity.setProviderId("organization");
        }
        Calendar createdCalendar = this.agendaCalendarService.createCalendar(calendar);
        Assert.assertNotNull((Object)createdCalendar);
        Assert.assertEquals((long)calendarId, (long)createdCalendar.getId());
        Assert.assertNotNull((Object)createdCalendar.getCreated());
        createdCalendar.setCreated(calendar.getCreated());
        createdCalendar.setId(calendar.getId());
        Assert.assertEquals((Object)calendar, (Object)createdCalendar);
    }

    @Test
    public void testCreateCalendarWithUsername() throws Exception {
        final long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "test";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Calendar calendar = new Calendar(0L, calendarOwnerId, true, "title", "description", null, null, "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.createCalendar((Calendar)Mockito.eq((Object)calendar))).thenAnswer((Answer)new Answer<Calendar>(){

            public Calendar answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Calendar calendar = (Calendar)args[0];
                calendar.setId(calendarId);
                calendar.setCreated(AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()));
                calendar.setUpdated(null);
                return calendar;
            }
        });
        try {
            this.agendaCalendarService.createCalendar(null, username);
            Assert.fail((String)"Shouldn't allow to create null calendar");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.createCalendar(calendar, null);
            Assert.fail((String)"Shouldn't allow to create null calendar");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            calendar.setId(1L);
            this.agendaCalendarService.createCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to create calendar with a not zero id");
        }
        catch (IllegalArgumentException e) {
            calendar.setId(0L);
        }
        try {
            calendar.setOwnerId(-1L);
            this.agendaCalendarService.createCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to create calendar with a negative owner id");
        }
        catch (IllegalStateException e) {
            calendar.setOwnerId(calendarOwnerId);
        }
        try {
            this.agendaCalendarService.createCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to create calendar with a not valid calendar owner");
        }
        catch (IllegalStateException e) {
            calendar.setOwnerId(calendarOwnerId);
        }
        Mockito.when((Object)this.identityManager.getIdentity(calendarOwnerIdentity.getId())).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)calendarOwnerIdentity);
        try {
            calendarOwnerIdentity.setProviderId("NotManagerProviderByCalendarAPI");
            this.agendaCalendarService.createCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to create calendar with not managed providerId for calendar owner");
        }
        catch (IllegalStateException e) {
            calendarOwnerIdentity.setProviderId("organization");
        }
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        Calendar createdCalendar = this.agendaCalendarService.createCalendar(calendar, username);
        Assert.assertNotNull((Object)createdCalendar);
        Assert.assertEquals((long)calendarId, (long)createdCalendar.getId());
        Assert.assertNotNull((Object)createdCalendar.getCreated());
        createdCalendar.setCreated(null);
        createdCalendar.setId(0L);
        Assert.assertEquals((Object)calendar, (Object)createdCalendar);
        String spacePrettyName = "spacetest";
        calendarOwnerIdentity = new Identity("space", spacePrettyName);
        calendarOwnerIdentity.setId(String.valueOf(++calendarOwnerId));
        calendar.setOwnerId(calendarOwnerId);
        Mockito.when((Object)this.identityManager.getIdentity(calendarOwnerIdentity.getId())).thenReturn((Object)calendarOwnerIdentity);
        Space space = new Space();
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)false);
        try {
            this.agendaCalendarService.createCalendar(calendar, username);
            Assert.fail((String)"User shouldn't be able to create space calendar");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        try {
            this.agendaCalendarService.createCalendar(calendar, username);
            Assert.fail((String)"User shouldn't be able to create space calendar even when member");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.canManageSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        createdCalendar = this.agendaCalendarService.createCalendar(calendar, username);
        Assert.assertNotNull((Object)createdCalendar);
        Assert.assertEquals((long)calendarId, (long)createdCalendar.getId());
        Assert.assertNotNull((Object)createdCalendar.getCreated());
        createdCalendar.setCreated(null);
        createdCalendar.setId(0L);
        Assert.assertEquals((Object)calendar, (Object)createdCalendar);
    }

    @Test
    public void testUpdateCalendar() throws Exception {
        final long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "test";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Calendar calendar = new Calendar(calendarId, calendarOwnerId, true, "title", "description", null, null, "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        ((AgendaCalendarStorage)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                Calendar calendar = (Calendar)args[0];
                calendar.setId(calendarId);
                calendar.setUpdated(AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()));
                return null;
            }
        }).when((Object)this.agendaCalendarStorage)).updateCalendar((Calendar)Mockito.eq((Object)calendar));
        try {
            this.agendaCalendarService.updateCalendar(null);
            Assert.fail((String)"Shouldn't allow to update null calendar");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            calendar.setId(0L);
            this.agendaCalendarService.updateCalendar(calendar);
            Assert.fail((String)"Shouldn't allow to update calendar with invalid id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            long notExistingCalendarId = calendarId + 1L;
            calendar.setId(notExistingCalendarId);
            this.agendaCalendarService.updateCalendar(calendar);
            Assert.fail((String)"Shouldn't allow to update calendar with a not found calendar");
        }
        catch (ObjectNotFoundException e) {
            calendar.setId(calendarId);
        }
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)0))).updateCalendar((Calendar)Mockito.any());
        this.agendaCalendarService.updateCalendar(calendar);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)1))).updateCalendar((Calendar)Mockito.any());
    }

    @Test
    public void testUpdateCalendarWithUsername() throws Exception {
        final long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "test";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Calendar calendar = new Calendar(calendarId, calendarOwnerId, true, "title", "description", null, null, "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        ((AgendaCalendarStorage)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                Calendar calendar = (Calendar)args[0];
                calendar.setId(calendarId);
                calendar.setUpdated(AgendaDateUtils.toRFC3339Date((ZonedDateTime)ZonedDateTime.now()));
                return null;
            }
        }).when((Object)this.agendaCalendarStorage)).updateCalendar((Calendar)Mockito.eq((Object)calendar));
        try {
            this.agendaCalendarService.updateCalendar(calendar, null);
            Assert.fail((String)"Shouldn't allow to update null calendar");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.updateCalendar(null, username);
            Assert.fail((String)"Shouldn't allow to update null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            calendar.setId(0L);
            this.agendaCalendarService.updateCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to update calendar with invalid id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            long notExistingCalendarId = calendarId + 1L;
            calendar.setId(notExistingCalendarId);
            this.agendaCalendarService.updateCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to update calendar with a not found calendar");
        }
        catch (ObjectNotFoundException e) {
            calendar.setId(calendarId);
        }
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)0))).updateCalendar((Calendar)Mockito.any());
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        try {
            calendarOwnerIdentity.setProviderId("NotManagerProviderByCalendarAPI");
            this.agendaCalendarService.updateCalendar(calendar, username);
            Assert.fail((String)"Shouldn't allow to update calendar with not managed providerId for calendar owner");
        }
        catch (IllegalStateException e) {
            calendarOwnerIdentity.setProviderId("organization");
        }
        this.agendaCalendarService.updateCalendar(calendar, username);
        Assert.assertEquals((long)calendarId, (long)calendar.getId());
        Assert.assertNotNull((Object)calendar.getUpdated());
        calendarOwnerIdentity.setProviderId("space");
        String spacePrettyName = "spacetest";
        calendarOwnerIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)false);
        try {
            this.agendaCalendarService.updateCalendar(calendar, username);
            Assert.fail((String)"User shouldn't be able to update space calendar");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        try {
            this.agendaCalendarService.updateCalendar(calendar, username);
            Assert.fail((String)"User shouldn't be able to update space calendar even when member");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canManageSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        calendar.setUpdated(null);
        this.agendaCalendarService.updateCalendar(calendar, username);
        Assert.assertNotNull((Object)calendar.getUpdated());
    }

    @Test
    public void testDeleteCalendarById() throws Exception {
        try {
            this.agendaCalendarService.deleteCalendarById(0L);
            Assert.fail((String)"Shouldn't be able to delete calendar with invalid id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.deleteCalendarById(1L);
            Assert.fail((String)"Shouldn't be able to delete a non existing calendar");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)0))).deleteCalendarById(Mockito.anyLong());
        long calendarId = 1L;
        Calendar calendar = new Calendar(calendarId, 2L, true, "title", "description", null, null, "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        this.agendaCalendarService.deleteCalendarById(calendarId);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)1))).deleteCalendarById(Mockito.anyLong());
    }

    @Test
    public void testDeleteCalendarByIdAndUsername() throws Exception {
        long calendarId = 1L;
        long calendarOwnerId = 2L;
        String username = "test";
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Calendar calendar = new Calendar(calendarId, calendarOwnerId, true, "title", "description", null, null, "color", null);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarById(Mockito.eq((long)calendarId))).thenReturn((Object)calendar);
        try {
            this.agendaCalendarService.deleteCalendarById(calendarId, null);
            Assert.fail((String)"Shouldn't allow to delete null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.deleteCalendarById(0L, username);
            Assert.fail((String)"Shouldn't allow to delete invalid calendar id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            long inexistantCalendarId = calendarId + 2L;
            this.agendaCalendarService.deleteCalendarById(inexistantCalendarId, username);
            Assert.fail((String)"Shouldn't allow to delete calendar with not existing calendar");
        }
        catch (ObjectNotFoundException inexistantCalendarId) {
            // empty catch block
        }
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)0))).deleteCalendarById(Mockito.anyLong());
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        try {
            calendarOwnerIdentity.setRemoteId("anotherUser");
            this.agendaCalendarService.deleteCalendarById(calendarId, username);
            Assert.fail((String)"Shouldn't allow to delete calendar with different user from calendar owner");
        }
        catch (IllegalStateException e) {
            calendarOwnerIdentity.setRemoteId(username);
        }
        try {
            calendar.setSystem(true);
            this.agendaCalendarService.deleteCalendarById(calendarId, username);
            Assert.fail((String)"Shouldn't allow to delete system calendar even by owner");
        }
        catch (IllegalStateException e) {
            calendar.setSystem(false);
        }
        this.agendaCalendarService.deleteCalendarById(calendarId, username);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)1))).deleteCalendarById(Mockito.eq((long)calendarId));
        calendarOwnerIdentity.setProviderId("space");
        String spacePrettyName = "spacetest";
        calendarOwnerIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)false);
        try {
            this.agendaCalendarService.deleteCalendarById(calendarId, username);
            Assert.fail((String)"User shouldn't be able to delete space calendar");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        try {
            this.agendaCalendarService.deleteCalendarById(calendarId, username);
            Assert.fail((String)"User shouldn't be able to delete space calendar even when member");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Mockito.when((Object)this.spaceService.canManageSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
        this.agendaCalendarService.deleteCalendarById(calendarId, username);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)2))).deleteCalendarById(Mockito.eq((long)calendarId));
        Mockito.when((Object)this.spaceService.canViewSpace((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)username))).thenReturn((Object)false);
        this.agendaCalendarService.deleteCalendarById(calendarId, username);
        ((AgendaCalendarStorage)Mockito.verify((Object)this.agendaCalendarStorage, (VerificationMode)Mockito.times((int)3))).deleteCalendarById(Mockito.eq((long)calendarId));
    }

    @Test
    public void testGetCalendars() throws Exception {
        try {
            this.agendaCalendarService.getCalendars(0, 10, null);
            Assert.fail((String)"shouldn't allow to retrieve calendars list with null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.getCalendars(0, 10, "fakeUser");
            Assert.fail((String)"Shouldn't allow to retrieve calendars list with inexistant username");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        final String username = "testuser";
        long calendarOwnerId = 2L;
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)username))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.spaceService.getMemberSpaces((String)Mockito.eq((Object)username))).thenAnswer((Answer)new Answer<ListAccess<Space>>(){

            public ListAccess<Space> answer(InvocationOnMock invocation) throws Throwable {
                ListAccess userSpaces = (ListAccess)Mockito.mock(ListAccess.class);
                int spacesCount = 45;
                Mockito.when((Object)userSpaces.getSize()).thenReturn((Object)45);
                Mockito.when((Object)((Space[])userSpaces.load(Mockito.anyInt(), Mockito.anyInt()))).thenAnswer((Answer)new Answer<Space[]>(){

                    public Space[] answer(InvocationOnMock invocation) throws Throwable {
                        Object[] args = invocation.getArguments();
                        int offset = Integer.parseInt(args[0].toString());
                        int size = Integer.parseInt(args[1].toString());
                        Space[] spaces = new Space[size];
                        for (int i = 0; i < size; ++i) {
                            spaces[i] = new Space();
                            int index = i + offset;
                            String prettyName = "testspace" + index;
                            int spaceIdentityIndex = index + 1000;
                            spaces[i].setId(String.valueOf(spaceIdentityIndex));
                            spaces[i].setPrettyName(prettyName);
                            Identity spaceIdentity = new Identity(String.valueOf(spaceIdentityIndex));
                            spaceIdentity.setProviderId("space");
                            spaceIdentity.setRemoteId(prettyName);
                            Mockito.when((Object)AgendaCalendarServiceTest.this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"space"), (String)Mockito.eq((Object)prettyName))).thenReturn((Object)spaceIdentity);
                            Mockito.when((Object)AgendaCalendarServiceTest.this.identityManager.getIdentity(spaceIdentity.getId())).thenReturn((Object)spaceIdentity);
                            Mockito.when((Object)AgendaCalendarServiceTest.this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)prettyName))).thenReturn((Object)spaces[i]);
                            Mockito.when((Object)AgendaCalendarServiceTest.this.spaceService.canViewSpace((Space)Mockito.eq((Object)spaces[i]), (String)Mockito.eq((Object)username))).thenReturn((Object)true);
                        }
                        return spaces;
                    }
                });
                return userSpaces;
            }
        });
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarIdsByOwnerIds(Mockito.anyInt(), Mockito.anyInt(), (Long[])Mockito.anyVararg())).thenAnswer((Answer)new Answer<List<Long>>(){

            public List<Long> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                int offset = Integer.parseInt(args[0].toString());
                int size = Integer.parseInt(args[1].toString());
                ArrayList<Long> ownerIds = new ArrayList<Long>();
                for (int i = 2; i < args.length; ++i) {
                    ownerIds.add((Long)invocation.getArgument(i, Long.class));
                }
                int from = offset;
                int to = from + size;
                to = to > 46 ? 46 : to;
                ArrayList<Long> calendarIds = new ArrayList<Long>(ownerIds.subList(from, to));
                for (Long calendarId : calendarIds) {
                    Mockito.when((Object)AgendaCalendarServiceTest.this.agendaCalendarStorage.getCalendarById(((Long)Mockito.eq((Object)calendarId)).longValue())).thenReturn((Object)new Calendar(calendarId.longValue(), calendarId.longValue(), false, "title", "description", "", null, "color", null));
                }
                return calendarIds;
            }
        });
        List calendars = this.agendaCalendarService.getCalendars(0, 10, username);
        Assert.assertNotNull((Object)calendars);
        Assert.assertEquals((long)10L, (long)calendars.size());
        for (Calendar calendar : calendars) {
            Assert.assertNotNull((Object)calendar);
        }
        calendars = this.agendaCalendarService.getCalendars(0, 50, username);
        Assert.assertNotNull((Object)calendars);
        Assert.assertEquals((long)46L, (long)calendars.size());
        for (Calendar calendar : calendars) {
            Assert.assertNotNull((Object)calendar);
        }
    }

    @Test
    public void testCountCalendars() throws Exception {
        try {
            this.agendaCalendarService.countCalendars(null);
            Assert.fail((String)"shouldn't allow to count calendars for null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.countCalendars("fakeUser");
            Assert.fail((String)"Shouldn't allow to count calendars for inexistant username");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String username = "testuser";
        long calendarOwnerId = 2L;
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)username))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.spaceService.getMemberSpaces((String)Mockito.eq((Object)username))).thenAnswer((Answer)new Answer<ListAccess<Space>>(){

            public ListAccess<Space> answer(InvocationOnMock invocation) throws Throwable {
                ListAccess userSpaces = (ListAccess)Mockito.mock(ListAccess.class);
                int spacesCount = 45;
                Mockito.when((Object)userSpaces.getSize()).thenReturn((Object)45);
                Mockito.when((Object)((Space[])userSpaces.load(Mockito.anyInt(), Mockito.anyInt()))).thenAnswer((Answer)new Answer<Space[]>(){

                    public Space[] answer(InvocationOnMock invocation) throws Throwable {
                        Object[] args = invocation.getArguments();
                        int offset = Integer.parseInt(args[0].toString());
                        int size = Integer.parseInt(args[1].toString());
                        Space[] spaces = new Space[size];
                        for (int i = 0; i < size; ++i) {
                            spaces[i] = new Space();
                            int index = i + offset;
                            String prettyName = "testspace" + index;
                            int spaceIdentityIndex = index + 1000;
                            spaces[i].setId(String.valueOf(spaceIdentityIndex));
                            spaces[i].setPrettyName(prettyName);
                            Identity spaceIdentity = new Identity(String.valueOf(spaceIdentityIndex));
                            spaceIdentity.setProviderId("space");
                            spaceIdentity.setRemoteId(prettyName);
                            Mockito.when((Object)AgendaCalendarServiceTest.this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"space"), (String)Mockito.eq((Object)prettyName))).thenReturn((Object)spaceIdentity);
                        }
                        return spaces;
                    }
                });
                return userSpaces;
            }
        });
        Mockito.when((Object)this.agendaCalendarStorage.countCalendarsByOwners((Long[])Mockito.anyVararg())).thenReturn((Object)45);
        long calendarsCount = this.agendaCalendarService.countCalendars(username);
        Assert.assertEquals((long)45L, (long)calendarsCount);
    }

    @Test
    public void testGetCalendarsByOwnerIds() throws Exception {
        String username = "testuser";
        try {
            this.agendaCalendarService.getCalendarsByOwnerIds(Collections.singletonList(1L), null);
            Assert.fail((String)"shouldn't allow to retrieve calendars list with null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaCalendarService.getCalendarsByOwnerIds(Collections.singletonList(1L), "fakeUser");
            Assert.fail((String)"Shouldn't allow to retrieve calendars list with inexistant username");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        final long calendarOwnerId = 2L;
        Identity calendarOwnerIdentity = new Identity("organization", username);
        calendarOwnerIdentity.setId(String.valueOf(calendarOwnerId));
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(calendarOwnerId)))).thenReturn((Object)calendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)username))).thenReturn((Object)calendarOwnerIdentity);
        long anotherCalendarOwnerId = 3L;
        String anotherUser = "username2";
        Identity anotherCalendarOwnerIdentity = new Identity("organization", anotherUser);
        anotherCalendarOwnerIdentity.setId(String.valueOf(anotherCalendarOwnerId));
        Mockito.when((Object)this.identityManager.getIdentity((String)Mockito.eq((Object)String.valueOf(anotherCalendarOwnerId)))).thenReturn((Object)anotherCalendarOwnerIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)anotherUser))).thenReturn((Object)anotherCalendarOwnerIdentity);
        Mockito.when((Object)this.agendaCalendarStorage.getCalendarIdsByOwnerIds(Mockito.anyInt(), Mockito.anyInt(), (Long[])Mockito.anyVararg())).thenAnswer((Answer)new Answer<List<Long>>(){

            public List<Long> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                int offset = Integer.parseInt(args[0].toString());
                int size = Integer.parseInt(args[1].toString());
                ArrayList<Long> ownerIds = new ArrayList<Long>();
                for (int i = 2; i < args.length; ++i) {
                    ownerIds.add((Long)invocation.getArgument(i, Long.class));
                }
                ArrayList<Long> calendarIds = new ArrayList<Long>();
                int length = offset + size;
                length = length > 45 ? 45 : length;
                for (long i = (long)offset; i < (long)length; ++i) {
                    calendarIds.add(i + 1L);
                }
                for (Long calendarId : calendarIds) {
                    Mockito.when((Object)AgendaCalendarServiceTest.this.agendaCalendarStorage.getCalendarById(((Long)Mockito.eq((Object)calendarId)).longValue())).thenReturn((Object)new Calendar(calendarId.longValue(), calendarOwnerId, false, "title", "description", "", null, "color", null));
                }
                return calendarIds;
            }
        });
        List calendars = this.agendaCalendarService.getCalendarsByOwnerIds(Collections.singletonList(calendarOwnerId), username);
        Assert.assertNotNull((Object)calendars);
        Assert.assertEquals((long)45L, (long)calendars.size());
    }
}

