/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="MalwareDetectionPlugin", template="war:/notification/templates/web/MalwareDetectionPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"MalwareDetectionPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String infectedItemName = notificationInfo.getValueOwnerParameter("infectedItemName");
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notificationInfo.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.parseBoolean(notificationInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notificationInfo.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"INFECTED_ITEM_NAME", (Object)infectedItemName);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

