/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/malware/detection")
@Tag(name="/malware", description="Malware detection")
public class MalwareDetectionRestService
implements ResourceContainer {
    private static final String MALWARE_DETECTION_PASSPHRASE_PROPERTY = "exo.malwareDetection.passphrase";
    private MalwareDetectionService malwareDetectionService;
    private String malwareDetectionPassphrase;

    public MalwareDetectionRestService(MalwareDetectionService malwareDetectionService) {
        this.malwareDetectionService = malwareDetectionService;
        this.malwareDetectionPassphrase = System.getProperty(MALWARE_DETECTION_PASSPHRASE_PROPERTY);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Process infected items", method="POST", description="This processes infected items")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized to process infected items")})
    public Response processInfectedItems(@Parameter(description="List of infected items paths", required=true) List<String> infectedItemsPaths, @QueryParam(value="token") String token) throws Exception {
        if (token == null || this.malwareDetectionPassphrase == null || !this.malwareDetectionPassphrase.equals(token)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        for (String infectedItemPath : infectedItemsPaths) {
            this.malwareDetectionService.processInfectedItem(infectedItemPath);
        }
        return Response.ok().entity((Object)("{\"result\":\"" + infectedItemsPaths + "\"}")).build();
    }
}

