/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.listener;

import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class AntiMalwareNotificationListener
extends Listener<String, Object> {
    @Autowired
    private ListenerService listenerService;
    private static final String MALWARE_DETECTION_PLUGIN_ID = "MalwareDetectionPlugin";
    private static final String INFECTED_ITEM_NAME = "infectedItemName";
    private static final String INFECTED_ITEM_LAST_MODIFIER = "infectedItemLastModifier";
    private static final String INFECTED_FILE_CLEANED = "infected-file-cleaned";
    private static final ArgumentLiteral<String> INFECTED_ITEM_NAME_ARGUMENT = new ArgumentLiteral(String.class, "infectedItemName");
    private static final ArgumentLiteral<String> INFECTED_ITEM_LAST_MODIFIER_ARGUMENT = new ArgumentLiteral(String.class, "infectedItemLastModifier");
    private final String[] eventTypes = new String[]{"infected-file-cleaned"};

    @PostConstruct
    public void init() {
        for (String eventType : this.eventTypes) {
            this.listenerService.addListener(eventType, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, Object> event) throws Exception {
        Map infectedItem = (Map)event.getData();
        if (infectedItem == null) {
            return;
        }
        this.sendInfectedItemNotification(infectedItem);
    }

    private void sendInfectedItemNotification(Map<String, String> infectedItem) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(INFECTED_ITEM_NAME_ARGUMENT, (Object)infectedItem.get(INFECTED_ITEM_NAME));
        ctx.append(INFECTED_ITEM_LAST_MODIFIER_ARGUMENT, (Object)infectedItem.get(INFECTED_ITEM_LAST_MODIFIER));
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)MALWARE_DETECTION_PLUGIN_ID))).execute(ctx);
    }
}

