/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.notification.plugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class MalwareDetectionPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(MalwareDetectionPlugin.class);
    private final OrganizationService organizationService;
    public static final String ID = "MalwareDetectionPlugin";
    private static final String DLP_GROUP = "/platform/dlp";
    private static final String ADMINS_GROUP = "/platform/administrators";

    public MalwareDetectionPlugin(InitParams initParams, OrganizationService organizationService) {
        super(initParams);
        this.organizationService = organizationService;
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        String infectedItemName = (String)ctx.value(MalwareDetectionItemConnector.INFECTED_ITEM_NAME_ARGUMENT);
        String infectedItemLastModifier = (String)ctx.value(MalwareDetectionItemConnector.INFECTED_ITEM_LAST_MODIFIER_ARGUMENT);
        NotificationInfo notificationInfo = NotificationInfo.instance().key(this.getId());
        notificationInfo.with("infectedItemName", infectedItemName);
        notificationInfo.to(this.getListReceivers(infectedItemLastModifier));
        return notificationInfo;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    private List<String> getListReceivers(String owner) {
        try {
            ListAccess usersList = this.organizationService.getUserHandler().findUsersByGroupId(DLP_GROUP);
            ListAccess adminsList = this.organizationService.getUserHandler().findUsersByGroupId(ADMINS_GROUP);
            List<User> users = Arrays.asList((User[])usersList.load(0, usersList.getSize()));
            List<User> admins = Arrays.asList((User[])adminsList.load(0, adminsList.getSize()));
            return Stream.concat(Stream.concat(users.stream().map(User::getUserName), admins.stream().map(User::getUserName)), Stream.of(owner)).distinct().toList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to list receivers for MalwareDetection notification plugin", (Throwable)e);
            return List.of(owner);
        }
    }
}

