/*
 * Copyright (C) 2022 eXo Platform SAS
 *
 *  This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <gnu.org/licenses>.
 */
package org.exoplatform.antimalware.connector;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;

/**
 * Is extended by all MalwareDetection connectors, and allows to build configuration needed by a list of connectors that is used for Malware detection.
 *
 */
public abstract class MalwareDetectionConnector extends BaseComponentPlugin {
  
  private String type;
  private boolean isDefault = false;
  protected static final String MALWARE_DETECTION_FEATURE = "malware-detection";
  protected static final String GET_MALWARE_INFECTED_ITEMS_PATHS_OPERATION = "get-malware-infected-items-paths";
  
  /**
   * Initializes a malware detection connector. The constructor is default that connectors must implement.
   * @param initParams The parameters which are used for initializing the malware detection connector from configuration.
   * @LevelAPI Experimental
   */
  public MalwareDetectionConnector(InitParams initParams) {
    PropertiesParam param = initParams.getPropertiesParam("constructor.params");
    this.type = param.getProperty("type");
    if (StringUtils.isNotBlank(param.getProperty("isDefault"))) {
      this.setDefault(Boolean.parseBoolean(param.getProperty("isDefault")));
    }
  }
  
  /**
   * @return the type
   */
  public String getType() {
    return type;
  }

  /**
   * @param type the type to set
   */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * @return the isDefault
   */
  public boolean isDefault() {
    return isDefault;
  }

  /**
   * @param isDefault the isDefault to set
   */
  public void setDefault(boolean isDefault) {
    this.isDefault = isDefault;
  }
  
  public abstract List<String> getInfectedItemsPaths();
}