/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.exoplatform.antimalware.connector.ExternalFileSystemItemConnector;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class ExternalFileSystemItemConnectorTest {
    @InjectMocks
    private ExternalFileSystemItemConnector connector;
    @Mock
    private MalwareDetectionService malwareDetectionService;
    @Mock
    private ListenerService listenerService;

    ExternalFileSystemItemConnectorTest() {
    }

    @BeforeEach
    void setUp() {
        this.connector.init();
        ReflectionTestUtils.setField((Object)this.connector, (String)"malwareDetectionService", (Object)this.malwareDetectionService);
        ReflectionTestUtils.setField((Object)this.connector, (String)"listenerService", (Object)this.listenerService);
    }

    @Test
    void testCanProcessInfectedItem() {
        String externalPath = "/external/path/file.txt";
        String jcrPath = File.separator + "jcr" + File.separator + "something";
        String filesPath = File.separator + "files" + File.separator + "something";
        Assertions.assertTrue((boolean)this.connector.canProcessInfectedItem(externalPath));
        Assertions.assertFalse((boolean)this.connector.canProcessInfectedItem(jcrPath));
        Assertions.assertFalse((boolean)this.connector.canProcessInfectedItem(filesPath));
    }

    @Test
    void testGetInfectedItems() {
        String path = "/some/path/infected.txt";
        List items = this.connector.getInfectedItems(path);
        Assertions.assertEquals((int)1, (int)items.size());
        Map item = (Map)items.getFirst();
        Assertions.assertEquals((Object)path, item.get("infectedItemPath"));
        Assertions.assertEquals((Object)"externalFileSystem", item.get("externalFileSystem"));
    }

    @Test
    void testCleanInfectedItem() {
        Map<String, String> infectedItem = Map.of("infectedItemPath", "/some/path/infected.txt", "externalFileSystem", "externalFileSystem");
        this.connector.cleanInfectedItem(infectedItem);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast((String)Mockito.eq((Object)"clean-file-infected"), (Object)((String)Mockito.eq((Object)"externalFileSystem")), (Object)((Map)Mockito.eq(infectedItem)));
    }

    @Test
    void testProcessInfectedItem() {
        String path = "/external/path/infected.txt";
        this.connector.processInfectedItem(path);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Map.class);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast((String)Mockito.eq((Object)"clean-file-infected"), (Object)((String)Mockito.eq((Object)"externalFileSystem")), (Object)((Map)captor.capture()));
        Map capturedItem = (Map)captor.getValue();
        Assertions.assertEquals((Object)path, capturedItem.get("infectedItemPath"));
        Assertions.assertEquals((Object)"externalFileSystem", capturedItem.get("externalFileSystem"));
    }
}

