/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.notification.plugin;

import java.util.List;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.antimalware.notification.plugin.MalwareDetectionPlugin;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MalwareDetectionPluginTest {
    @Mock
    private OrganizationService organizationService;
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    @Mock
    private InitParams initParams;
    private MalwareDetectionPlugin malwareDetectionPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.malwareDetectionPlugin = new MalwareDetectionPlugin(this.initParams, this.organizationService);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void makeNotification() throws Exception {
        User dlpUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)dlpUser.getUserName()).thenReturn((Object)"dlpUser");
        User adminUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)adminUser.getUserName()).thenReturn((Object)"adminUser");
        ListAccess dlpListAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)((User[])dlpListAccess.load(Mockito.anyInt(), Mockito.anyInt()))).thenReturn((Object)new User[]{dlpUser});
        Mockito.when((Object)dlpListAccess.getSize()).thenReturn((Object)1);
        ListAccess adminListAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)((User[])adminListAccess.load(Mockito.anyInt(), Mockito.anyInt()))).thenReturn((Object)new User[]{adminUser});
        Mockito.when((Object)adminListAccess.getSize()).thenReturn((Object)1);
        UserHandler userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        Mockito.when((Object)userHandler.findUsersByGroupId("/platform/dlp")).thenReturn((Object)dlpListAccess);
        Mockito.when((Object)userHandler.findUsersByGroupId("/platform/administrators")).thenReturn((Object)adminListAccess);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(MalwareDetectionItemConnector.INFECTED_ITEM_NAME_ARGUMENT, (Object)"file.docx");
        ctx.append(MalwareDetectionItemConnector.INFECTED_ITEM_LAST_MODIFIER_ARGUMENT, (Object)"john");
        NotificationInfo notificationInfo = this.malwareDetectionPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"file.docx", (Object)notificationInfo.getValueOwnerParameter(MalwareDetectionItemConnector.INFECTED_ITEM_NAME_ARGUMENT.getKey()));
        List receivers = notificationInfo.getSendToUserIds();
        Assert.assertEquals((long)3L, (long)receivers.size());
        Assert.assertTrue((boolean)receivers.contains("dlpUser"));
        Assert.assertTrue((boolean)receivers.contains("adminUser"));
        Assert.assertTrue((boolean)receivers.contains("john"));
    }
}

