/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.antimalware.connector.MalwareDetectionJcrConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MalwareDetectionJcrConnectorTest {
    private static final MockedStatic<WCMCoreUtils> WCM_CORE_UTILS = Mockito.mockStatic(WCMCoreUtils.class);
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ListenerService listenerService;
    private MalwareDetectionJcrConnector malwareDetectionJcrConnector;

    @AfterClass
    public static void afterRunBare() throws Exception {
        WCM_CORE_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        InitParams params = new InitParams();
        PropertiesParam constructorParams = new PropertiesParam();
        constructorParams.setName("constructor.params");
        constructorParams.setProperty("type", "files");
        constructorParams.setProperty("enabled", "true");
        params.addParameter((Parameter)constructorParams);
        this.malwareDetectionJcrConnector = new MalwareDetectionJcrConnector(params, this.repositoryService, this.listenerService);
    }

    @Test
    public void getInfectedItems() throws Exception {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Property jcrDataProperty = (Property)Mockito.mock(Property.class);
        Property lastModifier = (Property)Mockito.mock(Property.class);
        Node infectedJcrContentNode = (Node)Mockito.mock(Node.class);
        NodeImpl infectedJcrNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)jcrDataProperty.getName()).thenReturn((Object)"jcr:data");
        Mockito.when((Object)infectedJcrNode.getIdentifier()).thenReturn((Object)"8cd8");
        Mockito.when((Object)infectedJcrNode.getName()).thenReturn((Object)"file");
        Mockito.when((Object)jcrDataProperty.getParent()).thenReturn((Object)infectedJcrContentNode);
        Mockito.when((Object)infectedJcrContentNode.getParent()).thenReturn((Object)infectedJcrNode);
        Mockito.when((Object)session.getPropertyByIdentifier(ArgumentMatchers.anyString())).thenReturn((Object)jcrDataProperty);
        Mockito.when((Object)lastModifier.getString()).thenReturn((Object)"user");
        Mockito.when((Object)infectedJcrNode.getProperty("exo:lastModifier")).thenReturn((Object)lastModifier);
        List infectedItems = this.malwareDetectionJcrConnector.getInfectedItems("gatein/data/jcr/values/collaboration_portal/8/c/d/8/62bea6cf7f000101262f2b4a4c7638680");
        Assert.assertEquals((long)1L, (long)infectedItems.size());
        Assert.assertEquals((Object)"8cd8", ((Map)infectedItems.get(0)).get("infectedItemId"));
        Assert.assertEquals((Object)"file", ((Map)infectedItems.get(0)).get("infectedItemName"));
        Assert.assertEquals((Object)"user", ((Map)infectedItems.get(0)).get("infectedItemLastModifier"));
    }

    @Test
    public void canProcessInfectedItem() {
        Assert.assertTrue((boolean)this.malwareDetectionJcrConnector.canProcessInfectedItem("gatein/data/jcr/values/collaboration_portal8/c/d/8/62bea6cf7f000101262f2b4a4c7638680"));
        Assert.assertFalse((boolean)this.malwareDetectionJcrConnector.canProcessInfectedItem("gatein/data/files/8/c/d/8/62bea6cf7f000101262f2b4a4c7638680"));
    }

    @Test
    public void cleanInfectedItem() throws RepositoryException {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Node infectedJcrNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getNodeByIdentifier("8cd8")).thenReturn((Object)infectedJcrNode);
        HashMap<String, String> infectedItem = new HashMap<String, String>();
        infectedItem.put("infectedItemId", "8cd8");
        infectedItem.put("infectedJcrNodeWorkspace", "collaboration");
        this.malwareDetectionJcrConnector.cleanInfectedItem(infectedItem);
        ((Node)Mockito.verify((Object)infectedJcrNode, (VerificationMode)Mockito.times((int)1))).remove();
        ((ExtendedSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
    }
}

