/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.listener;

import java.util.HashMap;
import org.exoplatform.antimalware.listener.AntiMalwareNotificationListener;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AntiMalwareNotificationListenerTest {
    @Mock
    private ListenerService listenerService;
    @InjectMocks
    private AntiMalwareNotificationListener listener;

    @Before
    public void setUp() {
        this.listener.init();
    }

    @Test
    public void testOnEvent_appendsArguments() throws Exception {
        HashMap<String, String> infectedItem = new HashMap<String, String>();
        infectedItem.put("infectedItemName", "file.txt");
        infectedItem.put("infectedItemLastModifier", "john");
        NotificationContext ctxSpy = (NotificationContext)Mockito.spy((Object)NotificationContextImpl.cloneInstance());
        try (MockedStatic ctxStatic = Mockito.mockStatic(NotificationContextImpl.class);){
            ctxStatic.when(NotificationContextImpl::cloneInstance).thenReturn((Object)ctxSpy);
            Event event = new Event("infected-file-cleaned", null, infectedItem);
            this.listener.onEvent(event);
            ((NotificationContext)Mockito.verify((Object)ctxSpy)).append((ArgumentLiteral)Mockito.eq((Object)new ArgumentLiteral(String.class, "infectedItemName")), Mockito.eq((Object)"file.txt"));
            ((NotificationContext)Mockito.verify((Object)ctxSpy)).append((ArgumentLiteral)Mockito.eq((Object)new ArgumentLiteral(String.class, "infectedItemLastModifier")), Mockito.eq((Object)"john"));
        }
    }
}

