/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Stream;
import org.exoplatform.antimalware.connector.MalwareDetectionConnector;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ClamAVMalwareDetectionConnector
extends MalwareDetectionConnector {
    private static final Log LOG = ExoLogger.getExoLogger(ClamAVMalwareDetectionConnector.class);
    @Value(value="${exo.malwareDetection.connector.clamav.report.path:${exo.data.dir}/clamav-report.txt}")
    private String reportPath = null;
    @Value(value="${exo.malwareDetection.connector.clamav.isDefault:false}")
    private boolean isDefault = false;
    private String type = "ClamAV";
    @Autowired
    private MalwareDetectionService malwareDetectionService;

    @PostConstruct
    public void init() {
        this.setType(this.type);
        this.setDefault(this.isDefault);
        this.malwareDetectionService.addMalwareDetectionConnector(this);
    }

    @Override
    public List<String> getInfectedItemsPaths() {
        List<String> infectedPaths;
        if (this.reportPath == null) {
            return List.of();
        }
        Path path = Paths.get(this.reportPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || this.isFileEmpty(path)) {
            return List.of();
        }
        try (Stream<String> lines = Files.lines(path);){
            infectedPaths = lines.map(String::trim).filter(line -> line.endsWith("FOUND")).map(line -> {
                String[] parts = line.split(": ", 2);
                return parts.length >= 1 ? parts[0].trim() : null;
            }).filter(p -> p != null && !p.isEmpty()).toList();
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading infected items paths from ClamAV report", (Throwable)e);
            return List.of();
        }
        this.clearReportFile(path);
        LOG.info("ClamAV scan found {} infected item(s)", new Object[]{infectedPaths.size()});
        return infectedPaths;
    }

    private void clearReportFile(Path path) {
        try {
            Files.newBufferedWriter(path, StandardOpenOption.TRUNCATE_EXISTING).close();
            LOG.debug("ClamAV report file truncated after processing: {}", new Object[]{this.reportPath});
        }
        catch (IOException ex) {
            LOG.warn("Failed to truncate ClamAV report file: {}", new Object[]{this.reportPath, ex});
        }
    }

    private boolean isFileEmpty(Path path) {
        try {
            return Files.size(path) == 0L;
        }
        catch (IOException e) {
            LOG.warn("Failed to check if ClamAV report file is empty: {}", new Object[]{this.reportPath, e});
            return false;
        }
    }
}

