/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark;

import com.sun.japex.JapexDriverBase;
import com.sun.japex.TestCase;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.AbstractWebdavTest;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.WebdavTestContext;

public class WebdavDriver
extends JapexDriverBase {
    public static final String WEBDAV_HOST = "webdav.host";
    public static final String WEBDAV_PORT = "webdav.port";
    public static final String WEBDAV_REALM = "webdav.realm";
    public static final String WEBDAV_USER = "webdav.user";
    public static final String WEBDAV_PASSWORD = "webdav.password";
    public static final String WEBDAV_WORKSPACE_PATH = "webdav.workspacePath";
    protected WebdavTestContext context;
    private AbstractWebdavTest test;

    public void initializeDriver() {
        if (!this.hasParam(WEBDAV_HOST)) {
            throw new RuntimeException("<webdav.host> parameter required");
        }
        if (!this.hasParam(WEBDAV_PORT)) {
            throw new RuntimeException("<webdav.port> parameter required");
        }
        if (!this.hasParam(WEBDAV_REALM)) {
            throw new RuntimeException("<webdav.realm> parameter required");
        }
        if (!this.hasParam(WEBDAV_USER)) {
            throw new RuntimeException("<webdav.user> parameter required");
        }
        if (!this.hasParam(WEBDAV_PASSWORD)) {
            throw new RuntimeException("<webdav.password> parameter required");
        }
        if (!this.hasParam(WEBDAV_WORKSPACE_PATH)) {
            throw new RuntimeException("<webdav.workspacePath> parameter required");
        }
        this.context = new WebdavTestContext();
        this.context = this.initContext(this.context);
    }

    public void prepare(TestCase tc) {
        try {
            this.test = this.testInstance(tc);
            this.test.doPrepare(tc, this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void run(TestCase tc) {
        try {
            this.test.doRun(tc, this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish(TestCase tc) {
        try {
            this.test.doFinish(tc, this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private synchronized AbstractWebdavTest testInstance(TestCase tc) {
        if (!tc.hasParam("exo.testClass")) {
            throw new RuntimeException("<exo.testClass> parameter required");
        }
        try {
            String testCaseName = tc.getParam("exo.testClass");
            return (AbstractWebdavTest)Class.forName(testCaseName).newInstance();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private synchronized WebdavTestContext initContext(WebdavTestContext context) {
        context.put(WEBDAV_HOST, this.getParam(WEBDAV_HOST));
        context.put(WEBDAV_PORT, this.getParam(WEBDAV_PORT));
        context.put(WEBDAV_USER, this.getParam(WEBDAV_USER));
        context.put(WEBDAV_PASSWORD, this.getParam(WEBDAV_PASSWORD));
        context.put(WEBDAV_REALM, this.getParam(WEBDAV_REALM));
        context.put(WEBDAV_WORKSPACE_PATH, this.getParam(WEBDAV_WORKSPACE_PATH));
        return context;
    }
}

