/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.helpers;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.SimpleCredentials;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.SessionImpl;

public class AddNtFileWithMetadataNoJapex {
    private static final int NUMBER_OF_ITERATIONS = 500;

    public static void main(String[] args) {
        ManageableRepository repository = null;
        try {
            StandaloneContainer.addConfigurationPath((String)"../config/test-configuration-benchmark.xml");
            StandaloneContainer container = StandaloneContainer.getInstance();
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource("login.conf").toString());
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            repository = repositoryService.getCurrentRepository();
            SimpleCredentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
            SessionImpl session = (SessionImpl)repository.login((Credentials)credentials, "collaboration");
            Node rootNode = session.getRootNode().addNode("rootNode", "nt:unstructured");
            session.save();
            long start = System.currentTimeMillis();
            for (int i = 0; i < 500; ++i) {
                Node nodeToAdd = rootNode.addNode("node" + i, "nt:file");
                Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream("../resources/benchmark.pdf"));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "application/pdf");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
            }
            long end = System.currentTimeMillis();
            rootNode.remove();
            session.save();
            System.out.println("===AddNtFileWithMetadataNoJapex, TIME : " + (end - start) / 500L + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

