/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.webdav;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.JCRWebdavConnectionEx;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.WebdavTestContext;

public abstract class AbstractWebdavTest {
    protected JCRWebdavConnectionEx item;
    protected String rootNodeName;
    private List<String> nodesPath = new ArrayList<String>();
    private volatile int iteration = 0;

    public void doPrepare(TestCase tc, WebdavTestContext context) throws Exception {
        int warmUpIterations;
        int runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            runIterations += warmUpIterations;
        }
        CookieModule.setCookiePolicyHandler(null);
        this.item = new JCRWebdavConnectionEx(context);
        this.rootNodeName = context.generateUniqueName("rootNode");
        this.item.addDir(this.rootNodeName);
        for (int i = 0; i < runIterations; ++i) {
            String parentNodeName = this.rootNodeName + "/" + context.generateUniqueName("node");
            this.item.addDir(parentNodeName);
            this.createContent(parentNodeName, tc, context);
        }
    }

    protected abstract void createContent(String var1, TestCase var2, WebdavTestContext var3) throws Exception;

    protected void addNode(String nodePath) {
        this.nodesPath.add(nodePath);
    }

    protected String nextNodePath() {
        return this.nodesPath.get(this.iteration++);
    }

    public void doFinish(TestCase tc, WebdavTestContext context) throws Exception {
        this.item.removeNode(this.rootNodeName);
        this.item.stop();
    }

    public abstract void doRun(TestCase var1, WebdavTestContext var2) throws Exception;
}

