/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.sessionregistry;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Credentials;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;

public abstract class AbstractSessionRegistryTest
extends JCRTestBase {
    protected SessionRegistry sessionRegistry;
    private List<SessionImpl> sessionList;
    private List<String> sessionIdList;
    private int indexSession = 0;
    private int indexSessionId = 0;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int warmUpIterations;
        super.doPrepare(tc, context);
        int runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            runIterations += warmUpIterations;
        }
        CredentialsImpl credentials = new CredentialsImpl("root", "exo".toCharArray());
        RepositoryImpl repository = (RepositoryImpl)context.getSession().getRepository();
        this.sessionRegistry = (SessionRegistry)((SessionImpl)context.getSession()).getContainer().getComponentInstanceOfType(SessionRegistry.class);
        this.sessionList = new ArrayList<SessionImpl>();
        this.sessionIdList = new ArrayList<String>();
        int sessionCount = tc.getIntParam("japex.numberOfThreads") * runIterations;
        for (int i = 0; i < sessionCount; ++i) {
            this.sessionList.add((SessionImpl)repository.login((Credentials)credentials, "system"));
            SessionImpl workSession = (SessionImpl)repository.login((Credentials)credentials, "system");
            this.sessionRegistry.registerSession(workSession);
            this.sessionIdList.add(workSession.getId());
        }
    }

    protected SessionImpl nextSession() {
        return this.sessionList.get(this.indexSession++);
    }

    protected String nextSessionId() {
        return this.sessionIdList.get(this.indexSessionId++);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.sessionList.clear();
        this.sessionList = null;
        this.sessionIdList.clear();
        this.sessionIdList = null;
        super.doFinish(tc, context);
    }
}

