/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.nodetype;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractNodeTypeTest
extends JCRTestBase {
    private static final Log LOG = ExoLogger.getLogger(AbstractNodeTypeTest.class);
    protected ExtendedNodeTypeManager extNodeTypeManager;
    protected List<NodeTypeValue> nodeTypes = new ArrayList<NodeTypeValue>();
    protected int iteration = 0;
    protected int runIterations;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int warmUpIterations;
        super.doPrepare(tc, context);
        this.extNodeTypeManager = (ExtendedNodeTypeManager)context.getSession().getWorkspace().getNodeTypeManager();
        this.runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            this.runIterations += warmUpIterations;
        }
        this.prepare(tc, context);
    }

    protected NodeTypeValue nextNodeTypeValue() {
        return this.nodeTypes.get(this.iteration++);
    }

    public void doFinish(TestCase arg0, JCRTestContext arg1) throws Exception {
        super.doFinish(arg0, arg1);
        for (NodeTypeValue nt : this.nodeTypes) {
            try {
                this.extNodeTypeManager.getNodeType(nt.getName());
                this.extNodeTypeManager.unregisterNodeType(nt.getName());
            }
            catch (NoSuchNodeTypeException e) {}
        }
        this.nodeTypes.clear();
    }

    public abstract void prepare(TestCase var1, JCRTestContext var2) throws Exception;
}

