/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.portal;

import com.sun.japex.TestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.usecases.portal.AbstractAction;
import org.exoplatform.jcr.benchmark.usecases.portal.InitRepositoryAction;
import org.exoplatform.jcr.benchmark.usecases.portal.ReadPageAction;
import org.exoplatform.jcr.benchmark.usecases.portal.WritePageAction;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageUsecasesTest
extends JCRTestBase {
    static final Log log = ExoLogger.getLogger((String)PageUsecasesTest.class.getName());
    private static final String PARAM_DEPTH = "exo.prepare.depth";
    private static final String PARAM_NODES_PER_LEVEL = "exo.prepare.nodesPerLevel";
    private static final String PARAM_STRING_LENGTH = "exo.data.stringLength";
    private static final String PARAM_MULTI_SIZE = "exo.data.multiValueSize";
    private static final String PARAM_BIN_PATH = "exo.data.binaryPath";
    private static final String PARAM_BIN_SIZE = "exo.data.binarySize";
    private static final String PARAM_SCENARIO = "exo.scenario.string";
    private static final String PARAM_CELANUP = "exo.finish.cleanup";
    private static final String PARAM_PREPARE_SYNCHRONISATION = "exo.prepare.synchronisation";
    private static final String PARAM_FINISH_SYNCHRONISATION = "exo.finish.synchronisation";
    private static final String PARAM_FINISH_SYNCHRONISATION_SLEEPTIME = "exo.finish.synchronisation.sleepTime";
    private static final String PARAM_WAIT_THREADS = "exo.synchronisation.waitThread";
    private static final String PARAM_SYNCHRONISATION_NONE = "none";
    private static final String PARAM_SYNCHRONISATION_KEYPRESS = "keypress";
    private static final String PARAM_SYNCHRONISATION_SLEEP = "sleep";
    private static final String CASE_READ_ANON = "ReadAnon";
    private static final String CASE_READ_CONN = "Read";
    private static final String CASE_WRITE_CONN = "Write";
    private int depth = 2;
    private int nodesPerLevel = 10;
    private int stringLength = 64;
    private int multiValueSize = 2;
    private String binaryPath = null;
    private int binarySize = 1024;
    private String rootNodeName;
    private Random random = new Random();
    private static String stringValue = null;
    private static byte[] binaryValue = null;
    private List<AbstractAction> scenario = null;
    private final AtomicInteger index = new AtomicInteger();
    private static int keyPressThreadCounter = 0;
    private static int timeoutThreadCounter = 0;

    public static synchronized void waitUntilKeyPressed(int timesToWait) throws IOException {
        if (++keyPressThreadCounter >= timesToWait) {
            System.out.print("Press Enter to continue ...");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            in.readLine();
            System.out.println("Continuing ...");
            keyPressThreadCounter = 0;
        }
    }

    public static synchronized void waitUntilTimeout(int timesToWait, int sleepTime) {
        if (++timeoutThreadCounter >= timesToWait) {
            System.out.println("Waiting " + sleepTime / 1000 + "s before continue ...");
            timeoutThreadCounter = 0;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        if (tc.hasParam(PARAM_DEPTH)) {
            this.depth = tc.getIntParam(PARAM_DEPTH);
        }
        if (tc.hasParam(PARAM_NODES_PER_LEVEL)) {
            this.nodesPerLevel = tc.getIntParam(PARAM_NODES_PER_LEVEL);
        }
        if (tc.hasParam(PARAM_STRING_LENGTH)) {
            this.stringLength = tc.getIntParam(PARAM_STRING_LENGTH);
        }
        if (tc.hasParam(PARAM_MULTI_SIZE)) {
            this.multiValueSize = tc.getIntParam(PARAM_MULTI_SIZE);
        }
        if (tc.hasParam(PARAM_BIN_PATH)) {
            this.binaryPath = tc.getParam(PARAM_BIN_PATH);
        }
        if (tc.hasParam(PARAM_BIN_SIZE)) {
            this.binarySize = tc.getIntParam(PARAM_BIN_SIZE);
        }
        if (!tc.hasParam(PARAM_SCENARIO)) {
            throw new Exception("Scenario not found in configuration, but it is mandatory. Please define scenario as testCase parameter 'exo.scenario.string'.");
        }
        String scenarioString = tc.getParam(PARAM_SCENARIO);
        PageUsecasesTest pageUsecasesTest = this;
        synchronized (pageUsecasesTest) {
            if (stringValue == null) {
                byte[] bytes = new byte[this.stringLength];
                this.random.nextBytes(bytes);
                stringValue = new String(bytes);
            }
            if (binaryValue == null) {
                if (this.binaryPath == null) {
                    binaryValue = new byte[this.binarySize];
                    this.random.nextBytes(binaryValue);
                } else {
                    File file = new File(this.binaryPath);
                    FileInputStream fin = new FileInputStream(file);
                    binaryValue = new byte[(int)file.length()];
                    fin.read(binaryValue);
                    fin.close();
                }
            }
        }
        Session session = context.getSession();
        RepositoryImpl repository = (RepositoryImpl)context.getSession().getRepository();
        this.rootNodeName = IdGenerator.generate();
        session.getRootNode().addNode(this.rootNodeName, "exo:genericNode");
        session.save();
        this.scenario = this.parse(tc, scenarioString, repository, session.getWorkspace().getName(), this.rootNodeName);
        if (this.scenario.size() < 1) {
            throw new Exception("Scenario is empty. It must contain at least 1 usecase.");
        }
        InitRepositoryAction initAction = new InitRepositoryAction(session, this.rootNodeName, stringValue, binaryValue, this.multiValueSize, this.depth, this.nodesPerLevel);
        initAction.perform();
        session.save();
        if (tc.hasParam(PARAM_PREPARE_SYNCHRONISATION)) {
            String synch = tc.getParam(PARAM_PREPARE_SYNCHRONISATION);
            if (synch.equalsIgnoreCase(PARAM_SYNCHRONISATION_KEYPRESS)) {
                int thrWait = 1;
                if (tc.hasParam(PARAM_WAIT_THREADS)) {
                    thrWait = tc.getIntParam(PARAM_WAIT_THREADS);
                }
                PageUsecasesTest.waitUntilKeyPressed(thrWait);
            } else if (!synch.equalsIgnoreCase(PARAM_SYNCHRONISATION_NONE)) {
                log.warn((Object)("Unknown prepare synchronization method: " + synch));
            }
        }
    }

    @Override
    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        this.scenario.get(this.index.getAndIncrement() % this.scenario.size()).perform();
    }

    private List<AbstractAction> parse(TestCase tc, String line, RepositoryImpl repository, String workspace, String rootNodeName) throws Exception {
        String[] actionNames;
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        Pattern fullNotation = Pattern.compile("(\\d++)\\s*[*]\\s*(\\w++)\\s*[(]([,\\w.]*+)[)]");
        Pattern singleNotation = Pattern.compile("(\\w++)\\s*[(]([,\\w.]*+)[)]");
        for (String actionLine : actionNames = line.split("\\s*+;\\s*+")) {
            String[] params;
            String actionName;
            int times;
            Matcher fullMatcher = fullNotation.matcher(actionLine);
            if (fullMatcher.matches()) {
                times = Integer.parseInt(fullMatcher.group(1));
                actionName = fullMatcher.group(2);
                params = fullMatcher.group(3).split("\\s*+,\\s*+");
            } else {
                Matcher singleMatcher = singleNotation.matcher(actionLine);
                if (singleMatcher.matches()) {
                    times = 1;
                    actionName = singleMatcher.group(1);
                    params = singleMatcher.group(2).split("\\s*+,\\s*+");
                } else {
                    throw new Exception("Illegal scenario element:" + actionLine);
                }
            }
            for (int i = 0; i < times; ++i) {
                if (CASE_READ_ANON.equalsIgnoreCase(actionName)) {
                    if (params.length == 4) {
                        actions.add(new ReadPageAction(repository, workspace, rootNodeName, this.depth, Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]), Integer.parseInt(params[3]), true));
                        continue;
                    }
                    if (params.length == 5) {
                        actions.add(new ReadPageAction(repository, workspace, rootNodeName, this.depth, Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]), Integer.parseInt(params[3]), true, Arrays.asList(tc.getParam(params[4].trim()).split(";"))));
                        continue;
                    }
                    throw new Exception("Missing arguments for '" + actionName + "' action. Expected 4 or 5 arguments: number of JCR nodes and properties to read. Should be defined as '" + actionName + "(2,5,1,1)'" + " or '" + actionName + "(2,5,1,1,exo.query.list_1)'");
                }
                if (CASE_READ_CONN.equalsIgnoreCase(actionName)) {
                    if (params.length == 4) {
                        actions.add(new ReadPageAction(repository, workspace, rootNodeName, this.depth, Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]), Integer.parseInt(params[3]), false));
                        continue;
                    }
                    if (params.length == 5) {
                        actions.add(new ReadPageAction(repository, workspace, rootNodeName, this.depth, Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]), Integer.parseInt(params[3]), false, Arrays.asList(tc.getParam(params[4].trim()).split(";"))));
                        continue;
                    }
                    throw new Exception("Missing arguments for '" + actionName + "' action. Expected 4 or 5 arguments: number of JCR nodes and properties to read. Should be defined as '" + actionName + "(2,5,1,1)'" + " or '" + actionName + "(2,5,1,1,exo.query.list_1)'");
                }
                if (CASE_WRITE_CONN.equalsIgnoreCase(actionName)) {
                    if (params.length == 4) {
                        if (Integer.parseInt(params[0]) > Integer.parseInt(params[1])) {
                            throw new Exception("Wrong arguments for '" + actionName + "' action. Count of removed properties must be less or equal to count of setted properties: '" + actionName + "(" + params[0] + "," + params[1] + ",_,_)'");
                        }
                        if (Integer.parseInt(params[2]) > Integer.parseInt(params[3])) {
                            throw new Exception("Wrong arguments for '" + actionName + "' action. Count of removed nodes must be less or equal to count of added nodes: '" + actionName + "(_,_," + params[3] + "," + params[4] + ")'");
                        }
                        actions.add(new WritePageAction(repository, workspace, rootNodeName, this.depth, stringValue, binaryValue, this.multiValueSize, Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]), Integer.parseInt(params[3])));
                        continue;
                    }
                    throw new Exception("Missing arguments for '" + actionName + "' action. Expected 4 arguments: number of JCR nodes and properties to read. Should be defined as '" + actionName + "(2,5,1,3)'");
                }
                throw new Exception("Invalid usecase name: " + actionName);
            }
        }
        return Collections.unmodifiableList(actions);
    }

    @Override
    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        if (!tc.hasParam(PARAM_CELANUP) || tc.getBooleanParam(PARAM_CELANUP)) {
            Session session = context.getSession();
            session.refresh(false);
            session.getRootNode().getNode(this.rootNodeName).remove();
            session.save();
        }
        if (tc.hasParam(PARAM_FINISH_SYNCHRONISATION)) {
            String synch = tc.getParam(PARAM_FINISH_SYNCHRONISATION);
            if (synch.equalsIgnoreCase(PARAM_SYNCHRONISATION_KEYPRESS)) {
                int thrWait = 1;
                if (tc.hasParam(PARAM_WAIT_THREADS)) {
                    thrWait = tc.getIntParam(PARAM_WAIT_THREADS);
                }
                PageUsecasesTest.waitUntilKeyPressed(thrWait);
            } else if (synch.equalsIgnoreCase(PARAM_SYNCHRONISATION_SLEEP)) {
                int sleepTime = 20000;
                if (tc.hasParam(PARAM_FINISH_SYNCHRONISATION_SLEEPTIME)) {
                    sleepTime = 1000 * tc.getIntParam(PARAM_FINISH_SYNCHRONISATION_SLEEPTIME);
                }
                int thrWait = 1;
                if (tc.hasParam(PARAM_WAIT_THREADS)) {
                    thrWait = tc.getIntParam(PARAM_WAIT_THREADS);
                }
                PageUsecasesTest.waitUntilTimeout(thrWait, sleepTime);
            } else if (!synch.equalsIgnoreCase(PARAM_SYNCHRONISATION_NONE)) {
                log.warn((Object)("Unknown finish synchronization method: " + synch));
            }
        }
    }
}

