/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.version;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemTest;

public abstract class AbstractFailMergeTest
extends AbstractGetItemTest {
    private List<Version> versions = new ArrayList<Version>();
    private static final String workspaceName = "system";
    private Session sysSession;
    private volatile int versionIndex = 0;

    protected Version nextVersion() {
        return this.versions.get(this.versionIndex++);
    }

    protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
        Node vnode = parent.addNode(context.generateUniqueName("versionableNode"));
        vnode.addMixin("mix:versionable");
        parent.save();
        vnode.checkin();
        vnode.checkout();
        this.sysSession = context.getSession().getRepository().login(context.getCredentials(), workspaceName);
        if (!this.sysSession.itemExists(vnode.getParent().getPath())) {
            Node ctxNode = this.sysSession.getRootNode();
            for (String nname : vnode.getParent().getPath().split("/")) {
                try {
                    if (nname.equals("")) {
                        nname = ".";
                    }
                    ctxNode = ctxNode.getNode(nname);
                }
                catch (PathNotFoundException e) {
                    ctxNode = ctxNode.addNode(nname);
                    this.sysSession.save();
                }
            }
        }
        this.sysSession.getWorkspace().clone(context.getSession().getWorkspace().getName(), vnode.getPath(), vnode.getPath(), false);
        Node sysVNode = this.sysSession.getNodeByUUID(vnode.getUUID());
        vnode.addNode("Subnode").setProperty("Property", "property of subnode");
        vnode.save();
        vnode.checkin();
        vnode.checkout();
        sysVNode.addNode("Sys Subnode").setProperty("Sys Property", "property of system subnode");
        sysVNode.save();
        sysVNode.checkin();
        sysVNode.checkout();
        vnode.merge(workspaceName, true);
        this.addNode(vnode);
        Property mergeFailedProperty = vnode.getProperty("jcr:mergeFailed");
        Value[] mergeFailedReferences = mergeFailedProperty.getValues();
        String uuid = mergeFailedReferences[0].getString();
        this.versions.add((Version)this.sysSession.getNodeByUUID(uuid));
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        try {
            this.sysSession.getRootNode().getNode(this.rootNodeName).remove();
            this.sysSession.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }
}

