/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.webdav;

import com.sun.japex.TestCase;
import java.io.IOException;
import java.util.Random;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.HttpOutputStream;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.AbstractWebdavTest;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.WebdavTestContext;

public class WebdavAddBLOBTest
extends AbstractWebdavTest {
    private int sizeInMb = 0;

    public void doPrepare(TestCase tc, WebdavTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.sizeInMb = tc.getIntParam("blobFileSize");
    }

    protected void createContent(String parentNodeName, TestCase tc, WebdavTestContext context) throws Exception {
        String nodeName = parentNodeName + "/" + context.generateUniqueName(this.getClass().getName());
        this.addNode(nodeName);
    }

    public void doRun(TestCase tc, WebdavTestContext context) throws Exception {
        HttpOutputStream stream = new HttpOutputStream();
        HTTPResponse response = this.item.addNode(this.nextNodePath(), stream);
        this.loadStream(stream, this.sizeInMb * 1024);
        stream.close();
        response.getStatusCode();
    }

    public void doFinish(TestCase tc, WebdavTestContext context) throws Exception {
        super.doFinish(tc, context);
    }

    protected void loadStream(HttpOutputStream stream, int sizeInKb) throws IOException {
        byte[] data = new byte[1024];
        Random random = new Random();
        for (int i = 0; i < sizeInKb; ++i) {
            random.nextBytes(data);
            stream.write(data);
        }
    }
}

